'MMEDIT!!! Basic Version = Micromite_5.05.01
'MMEDIT!!! Port = COM29:38400:10,300
'MMEDIT!!! Device = Micromite_5.05.01
  'MMEDIT!!! Device = Micromite_5.05.01
  OPTION EXPLICIT
  OPTION BASE 0
  OPTION AUTORUN ON
  
  CONST BG_COL = RGB(BLACK)
  CONST FG_COL = RGB(WHITE)
  CONST FADE_COL = RGB(128,128,128)
  CONST BUT_COL = RGB(CYAN)
  CONST OK_COL =RGB(GREEN)
  CONST ERROR_COL = RGB(RED)
  CONST HL_COL = RGB(BLACK)
  CONST A_COL = RGB(128,128,128)
  CONST A_L = 34
  CONST A_R = 286
  CONST A_T = 36
  CONST A_B = 190
  CONST V_COL = RGB(RED)
  CONST I1_COL = RGB(YELLOW)
  CONST I2_COL = RGB(GREEN)
  CONST I3_COL = RGB(CYAN)
  CONST I4_COL = RGB(BLUE)
  CONST IO_ADDR = 32  'default for PCF8574, try 56 for PCB8574A
  
  ''using Micromite % units
  Dim Integer ON_BL
  Dim Integer IDLE_BL
  Dim Integer MN_TMOUT
  CONST IDLE_TOUT = 5000
  DIM INTEGER DISPLAY_TOUT
  ON_BL = 70
  IDLE_BL = 5
  MN_TMOUT = 55000
  
  '' AD7192 interface
  '' using HW SPI on 3/25/14 (MOSI/SCK/MISO)
  '' ~5MHz max frequency
  '' full scale = 2^24 (16777216)
  '' 2.5V reference with 39/1 divider => FS=100V
  '' nominal value of Vx_CAL is 100/16777216
  '' 15m# shunts for current
  const ADC_CS=24
  DIM FLOAT V_CAL(5)    'four multipliers by raw 24bit ADC value
  V_CAL(1)=100/16777216 ''nominal 100V/24bit full scale
  V_CAL(2)=V_CAL(1)
  V_CAL(3)=V_CAL(1)
  V_CAL(4)=V_CAL(1)
  'DIM FLOAT V_ACT(5),V_SAMPLE(5)    'four readings
  SETPIN ADC_CS,DOUT    ''this stays on at all times to keep CS high
  pin(ADC_CS)=1
  CONST ADC_TOUT = 1200  ''allows four samples/five seconds, typically takes 850ms/sample
  
  '' analog read on pin 4 for buck reg current shunt
  CONST SHUNT_ADC=4
  SETPIN SHUNT_ADC,AIN
  DIM FLOAT I_CAL(5)
  I_CAL(1) = -1/(100*0.1) '0.1# shunt with x100 gain same as 10# resistor. 1V => 100mA, result in A
  I_CAL(2) = -1/0.015  'nominal 15m# shunt
  I_CAL(3) = -1/0.015  'nominal 15m# shunt
  I_CAL(4) = -1/0.015  'nominal 15m# shunt
  
  DIM FLOAT I_RATIO(5)  ''used in alternate calibration, are ratio of I dividers to main V divider
  ''calculated on each sample ready for calibration, so V_CAL(2)=I_RATIO(2)*V_CAL(1) etc
  I_RATIO(2)=1
  I_RATIO(3)=1
  I_RATIO(4)=1
  
  ' globals used by Sub D_BUT
  CONST BUT_COUNT = 30
  Dim Integer key_coord(BUT_COUNT, 5)
  Dim String key_caption(BUT_COUNT)
  DIM INTEGER BUT_PRESS
  
  '  CONST SMOOTHING_FACTOR = 0  'number of samples over which data is exponentially smoothed ((OLD * SF)+ NEW)/(SF+1) 0=> no smoothing
  ''globals used as statics within subs
  ''sampling plan:
  ''channels take about a second each, so say 5s per scan, gives 12/min, 720/hr (hourly good for long term) ~2 days
  ''5 variables: Voltage and 4 currents
  
  DIM FLOAT NEW_RAW(10) 'for processing and smoothing
  NEW_RAW(0)=0
  NEW_RAW(1)=-1
  NEW_RAW(2)=0
  NEW_RAW(3)=0
  NEW_RAW(4)=0
  NEW_RAW(5)=0
  NEW_RAW(6)=0
  NEW_RAW(7)=0
  NEW_RAW(8)=0
  NEW_RAW(9)=0
  
  DIM INTEGER RAW_ACTUAL(6) 'raw smoothed ADC results
  RAW_ACTUAL(0)=0 'ignore 0 index
  RAW_ACTUAL(1)=-1 'voltage, set as error to flag at startup
  RAW_ACTUAL(2)=0 'current 1
  RAW_ACTUAL(3)=0 'current 2
  RAW_ACTUAL(4)=0 'current 3
  RAW_ACTUAL(5)=0 'current 4
  
  ''actual now values, in units of volts/amps- all floats are these units
  DIM FLOAT ACTUAL(6)
  ACTUAL(0)=0 'ignore 0 index
  ACTUAL(1)=0 'voltage
  ACTUAL(2)=0 'current 1
  ACTUAL(3)=0 'current 2
  ACTUAL(4)=0 'current 3
  ACTUAL(5)=0 'current 4
  
  ''for capacity checking
  DIM FLOAT V_FULL,V_EMPTY,I_SCALE,V_SHUTDOWN
  ''defaults for 12V
  V_FULL=14.4
  V_EMPTY=11.0
  V_SHUTDOWN=10.5
  I_SCALE=20
  
  ''usage tracking
  DIM FLOAT AH_SINCEF, AH_SINCEE, WH_SINCEF, WH_SINCEE
  DIM INTEGER USAGE_STATE
  AH_SINCEF=0
  AH_SINCEE=0
  WH_SINCEF=0
  WH_SINCEE=0
  USAGE_STATE=0 ' +1= min reached, +2=max reached => 3=data complete
  
  ''these are at the limit of VAR SAVE
  CONST S_COUNT = 720
  CONST H_COUNT = 48
  CONST D_COUNT = 10  ' 10 with 4 triggers, 6 with 8 triggers, 12 with 2 triggers, 13 with 1 trigger (ie D_COUNT+TRIG_COUNT<= 14)
  DIM INTEGER SAMPLE_STATE, SAMPLE_PTR
  SAMPLE_STATE=0
  SAMPLE_PTR=0 ''(is index into 720 below)
  ''these arrays are filled from the start and then 'scrolled'
  DIM INTEGER D_START, D_PTR  ''what is day of first item in D_SAMP (format?), pointer into D_SAMP array
  DIM INTEGER H_START, H_PTR  ''what is day of first item in H_SAMP (format?), pointer into H_SAMP array
  D_PTR=0
  H_PTR=0
  ''to be set by RTC or when needed
  D_START=0
  H_START=0
  DIM FLOAT SAMPLES(5,S_COUNT)  ''an hour of samples, this takes 17k of RAM, not saved
  DIM FLOAT H_SAMP(5,H_COUNT)  ''2 days of hourly samples
  DIM FLOAT D_SAMP(5,D_COUNT)   ''D_COUNT days of daily samples
  
  ''loop counters etc
  DIM I AS INTEGER
  ''mark values as invalid
  ''currents can be +/- so use V as flag
  FOR I = 0 to S_COUNT-1
    SAMPLES(0,I)=-1
    SAMPLES(1,I)=0
    SAMPLES(2,I)=0
    SAMPLES(3,I)=0
    SAMPLES(4,I)=0
  NEXT I
  FOR I = 0 to H_COUNT-1
    H_SAMP(0,I)=-1
    H_SAMP(1,I)=0
    H_SAMP(2,I)=0
    H_SAMP(3,I)=0
    H_SAMP(4,I)=0
  NEXT I
  FOR I = 0 to D_COUNT-1
    D_SAMP(0,I)=-1
    D_SAMP(1,I)=0
    D_SAMP(2,I)=0
    D_SAMP(3,I)=0
    D_SAMP(4,I)=0
  NEXT I
  
  'triggers, need to be saved
  CONST TRIG_COUNT=4
  DIM INTEGER TRIG_TRIP 'flag for live updates
  TRIG_TRIP=0
  DIM INTEGER TRIG_STATE(TRIG_COUNT)  'don't save this one as it doens't matter if it trips on powerup
  DIM STRING TRIG_COND(TRIG_COUNT) LENGTH 3 'eg "V <", "I1>"
  DIM FLOAT TRIG_THRESH(TRIG_COUNT)
  DIM INTEGER TRIG_SET(TRIG_COUNT) 'which switch outputs are activated (bitmask)
  DIM INTEGER TRIG_CLEAR(TRIG_COUNT) 'which triggers are reset (bitmask)
  FOR I = 0 TO TRIG_COUNT-1
    TRIG_STATE(I)=0 'OK
    TRIG_SET(I)=0 'nothing
    TRIG_CLEAR(I)=0 'nothing
    TRIG_COND(I)="   "  'no action
    TRIG_THRESH(I)=0
  NEXT I
  'typical VSR setup, in at 11V, out at 12.5V
  TRIG_SET(0)=1       'open, use S0 output
  TRIG_CLEAR(0)=2
  TRIG_COND(0)="V <"
  TRIG_THRESH(0)=11
  
  TRIG_SET(1)=2       'close, use S1 output
  TRIG_CLEAR(1)=1
  TRIG_COND(1)="V >"
  TRIG_THRESH(1)=12.5
  
  ''for Battery Balancer interface
  DIM FLOAT BB_V(5)   'Stack, C1-C4 voltages
  DIM FLOAT BB_I(4) 'C1-C4 currents as %, - is from cell to stack, positive is stack to cell
  'logged historical samples
  CONST BB_SAMPLES = 100
  CONST BB_D = (A_R-A_L)/(BB_SAMPLES*4) 'pixel dither to improve display
  DIM FLOAT BB_V_H(5,BB_SAMPLES)   'Stack, C1-C4 voltages
  DIM FLOAT BB_I_H(4,BB_SAMPLES) 'C1-C4 currents as %, - is from cell to stack, positive is stack to cell
  DIM INTEGER BB_S_PTR
  BB_S_PTR=0  'current sample, implement as circular buffer, ie current sample is most recent
  DIM INTEGER BB_SET_RATE 'used by controls on BB page
  BB_SET_RATE=1'multiples of 25%
  DIM STRING BB_STATUS,PADDING  'text from Balancer
  BB_STATUS=""
  PADDING="                    "'better than scattering strings around
  
  ''display state management
  DIM INTEGER DISPLAYSTATE
  DISPLAYSTATE=2 'on
  
  ''temp for calculation and display
  DIM INTEGER DISP_NUM
  
  ''SETUP
  VAR RESTORE
  VAR SAVE H_SAMP(),D_SAMP(),D_START, D_PTR,H_START, H_PTR, V_CAL(), I_CAL(),ON_BL,IDLE_BL,MN_TMOUT,V_EMPTY,V_FULL,AH_SINCEF, AH_SINCEE, WH_SINCEF, WH_SINCEE,I_SCALE,V_SHUTDOWN
  VAR SAVE TRIG_COND(),TRIG_THRESH(),TRIG_SET(),TRIG_CLEAR()
  
  LCD_ON  ''turn on LCD
  CLS(BG_COL)
  SET_BACKLIGHT(ON_BL)
  ''check RTC, ignore errors
  ON ERROR IGNORE
  RTC GETTIME
  ON ERROR ABORT
  DISPLAY_TOUT=TIMER     ''this is used to monitor our display timeout
  DIM STRING B_BUFFER     ''string used for Balancer data processing
  OPEN "COM1:38400, 1024" AS #8 'for Balancer interface
  DRAW_MAIN
  DO
    ''main loop, calls other routines as needed, they should DRAW_MAIN before returning
    SAMPLE_MANAGER    ''check sampling
    SAMPLE_MANAGER    ''do this twice as every second event happens quickly
    ''minute skipper for testing
    ''IF val(mid$(TIME$,4,2))<59 and val(mid$(TIME$,7,2))> 10 THEN SET_RTC(4,59):SET_RTC(5,45)  ''if minutes =1 , change to 59,so we can scroll through time quickly
    ''check buttons
    if DISPLAYSTATE>0 THEN
      'debug data for display timeout
      TEXT 315,0,right$(PADDING+str$(INT(((MN_TMOUT+IDLE_TOUT)-(TIMER-DISPLAY_TOUT))\1000)),8),RT,1,1,FG_COL,BG_COL
      'debug data for full/empty state 3=both states reached
      'TEXT 0,0,right$("   "+str$(USAGE_STATE),3),LT,1,1,FG_COL,BG_COL
      IF CHECK_SCREEN_TOUCH()=1 THEN
        DISPLAY_TOUT=TIMER ''counts time awake, reset if screen touched
        IF DISPLAYSTATE<2 THEN
          DISPLAYSTATE=2
          SET_BACKLIGHT(ON_BL)
        ENDIF
      ENDIF
      BUT_PRESS=CheckButtonPress(0, 4)
      IF BUT_PRESS >= 0 THEN
        ''wake up/set full backlight on button press in case we missed it
        DISPLAYSTATE=2
        SET_BACKLIGHT(ON_BL)
        CheckButtonRelease(BUT_PRESS)
        if BUT_PRESS=0 THEN DATA_MENU:BUT_PRESS=-1
        if BUT_PRESS=1 THEN SETTINGS_MENU:BUT_PRESS=-1
        if BUT_PRESS=2 THEN CALIBRATE_MENU:BUT_PRESS=-1
        if BUT_PRESS=3 THEN SOFT_SWITCH_MENU:BUT_PRESS=-1
        if BUT_PRESS=4 THEN BALANCER_MENU:BUT_PRESS=-1
      ENDIF
      ''display voltages etc on idle screen
      TEXT 160,68,"   "+DATE$+" "+TIME$+"   ",CT,1,1,FG_COL,BG_COL
      IF RAW_ACTUAL(1)<0 THEN ''sampling error
        TEXT 45,84,"ERROR",CT,1,1,ERROR_COL,BG_COL
      ELSE
        TEXT 45,84,"  OK  ",CT,1,1,FG_COL,BG_COL
      ENDIF
      TEXT 4,100,"V="+STR$(ACTUAL(1), 5, 2)+"V",LT,1,1,FG_COL,BG_COL
      TEXT 4,116,"I1="+STR$(ACTUAL(2), 4, 2)+"A",LT,1,1,FG_COL,BG_COL
      TEXT 4,132,"I2="+STR$(ACTUAL(3), 4, 2)+"A",LT,1,1,FG_COL,BG_COL
      TEXT 4,148,"I3="+STR$(ACTUAL(4), 4, 2)+"A",LT,1,1,FG_COL,BG_COL
      TEXT 4,164,"I4="+STR$(ACTUAL(5), 4, 2)+"A",LT,1,1,FG_COL,BG_COL
      IF V_FULL - V_EMPTY > 0.1 THEN
        DISP_NUM = ((ACTUAL(1)-V_EMPTY)*100)/(V_FULL - V_EMPTY)
        if DISP_NUM<0 THEN DISP_NUM=0
        IF DISP_NUM>100 THEN DISP_NUM=100
        TEXT 112,84,"CHGv="+STR$(DISP_NUM, 3, 0)+"%",LT,1,1,FG_COL,BG_COL
      ELSE
        TEXT 112,84,"CHGv=---%",LT,1,1,ERROR_COL,BG_COL
      ENDIF
      
      TEXT 112,116,"Ah since full= "+STR$(AH_SINCEF, 6, 1)+"Ah",LT,1,1,FG_COL,BG_COL
      TEXT 112,132,"Ah since empty="+STR$(AH_SINCEE, 6, 1)+"Ah",LT,1,1,FG_COL,BG_COL
      TEXT 112,148,"Wh since full= "+STR$(WH_SINCEF, 6, 1)+"Wh",LT,1,1,FG_COL,BG_COL
      TEXT 112,164,"Wh since empty="+STR$(WH_SINCEE, 6, 1)+"Wh",LT,1,1,FG_COL,BG_COL
      
      DISP_NUM=0
      'use this one to display capacity based on AH
      'IF (AH_SINCEF-AH_SINCEE)>0.1 THEN DISP_NUM = (-AH_SINCEE*100)/(AH_SINCEF-AH_SINCEE)
      'use this one to display capacity based on WH
      IF (WH_SINCEF-WH_SINCEE)>0.1 THEN DISP_NUM = (-WH_SINCEE*100)/(WH_SINCEF-WH_SINCEE)
      if DISP_NUM<0 THEN DISP_NUM=0
      IF DISP_NUM>100 THEN DISP_NUM=100
      IF USAGE_STATE>2 THEN
        TEXT 200,84,"CAP="+STR$(AH_SINCEF-AH_SINCEE, 6, 1)+"Ah",LT,1,1,FG_COL,BG_COL
        TEXT 200,100,"CAP="+STR$(WH_SINCEF-WH_SINCEE, 6, 1)+"Wh",LT,1,1,FG_COL,BG_COL
        TEXT 112,100,"CHGm="+STR$(DISP_NUM, 3, 0)+"%",LT,1,1,FG_COL,BG_COL
      ELSE
        TEXT 200,84,"CAP="+STR$(AH_SINCEF-AH_SINCEE, 6, 1)+"Ah",LT,1,1,FADE_COL,BG_COL
        TEXT 200,100,"CAP="+STR$(WH_SINCEF-WH_SINCEE, 6, 1)+"Wh",LT,1,1,FADE_COL,BG_COL
        TEXT 112,100,"CHGm="+STR$(DISP_NUM, 3, 0)+"%",LT,1,1,FADE_COL,BG_COL
      ENDIF
      ''mimics for triggers
      TEXT 220,218,"T:",LT,1,1,FG_COL,BG_COL
      FOR I = 0 TO TRIG_COUNT-1
        IF TRIG_STATE(I)>0 THEN
          TEXT 239+I*10,218,STR$(I),LT,1,1,ERROR_COL,BG_COL
        ELSE
          TEXT 239+I*10,218,STR$(I),LT,1,1,OK_COL,BG_COL
        ENDIF
      NEXT I
      ''update brightness and dim as needed
      ''fade
      IF (DISPLAYSTATE > 1) and ((TIMER-DISPLAY_TOUT)>MN_TMOUT) THEN
        DISPLAYSTATE=1
        SET_BACKLIGHT(IDLE_BL)
      ENDIF
      ''off
      IF ((TIMER-DISPLAY_TOUT)>MN_TMOUT+IDLE_TOUT) THEN
        DISPLAYSTATE=0
        SET_BACKLIGHT(0)
        LCD_OFF
      ENDIF
      PAUSE 50  ''wait a little between updates
    ELSE  ''wait for touches and reset
      IF ACTUAL(1)> V_SHUTDOWN THEN
        CPU SLEEP 1     ''this is how we get very low power
      ELSE
        CPU SLEEP 15    ''longer shutdown for low power, ADC goes to sleep after conversion
      ENDIF
      IF CHECK_SCREEN_TOUCH()=1 THEN
        DISPLAY_TOUT=TIMER ''counts time awake, reset if screen touched
        DISPLAYSTATE=2  ''fully awake
        LCD_ON
        CLS(BG_COL)    ''light up to let know that it's sensed the touch
        SET_BACKLIGHT(ON_BL)
        WAIT_FOR_RELEASE
        DRAW_MAIN                 ''draw display when touch released
      ENDIF
    ENDIF
  LOOP
  WATCHDOG 1 'in case we get here, restart
END
  
SUB BALANCER_MENU
  DRAW_BALANCER
  DO
    SAMPLE_MANAGER
    GET_BALANCER_DATA 'more frequent updates here for user info
    ''current state
    TEXT 10,62,"ST:"+STR$(BB_V(0),2,1)+"V",LT,8,1,FG_COL,BG_COL
    SHOW_BALANCER_STATE
    TEXT 160,60," C1:"+STR$(BB_V(1),2,1)+"V  C2:"+STR$(BB_V(2),2,1)+"V ",LT,1,1,FG_COL,BG_COL
    TEXT 160,80," C3:"+STR$(BB_V(3),2,1)+"V  C4:"+STR$(BB_V(4),2,1)+"V",LT,1,1,FG_COL,BG_COL
    BUT_PRESS=CheckButtonPress(0,15)
    IF BUT_PRESS >= 0 THEN
      CheckButtonRelease(BUT_PRESS)
      IF BUT_PRESS = 0 THEN BUT_PRESS=-1:EXIT DO
      IF BUT_PRESS = 1 THEN BALANCER_CMD("p")
      IF BUT_PRESS = 2 THEN BALANCER_CMD("r")
      IF BUT_PRESS = 3 THEN BALANCER_GRAPH:BUT_PRESS=-1:DRAW_BALANCER'go to graph page and resume when done
      
      IF BUT_PRESS = 4 THEN BALANCER_CMD("o1 "+STR$(BB_SET_RATE*25))
      IF BUT_PRESS = 5 THEN BALANCER_CMD("o2 "+STR$(BB_SET_RATE*25))
      IF BUT_PRESS = 6 THEN BALANCER_CMD("o3 "+STR$(BB_SET_RATE*25))
      IF BUT_PRESS = 7 THEN BALANCER_CMD("o4 "+STR$(BB_SET_RATE*25))
      
      IF BUT_PRESS = 8 THEN BALANCER_CMD("i1 "+STR$(BB_SET_RATE*25))
      IF BUT_PRESS = 9 THEN BALANCER_CMD("i2 "+STR$(BB_SET_RATE*25))
      IF BUT_PRESS = 10 THEN BALANCER_CMD("i3 "+STR$(BB_SET_RATE*25))
      IF BUT_PRESS = 11 THEN BALANCER_CMD("i4 "+STR$(BB_SET_RATE*25))
      
      IF BUT_PRESS = 12 THEN BB_SET_RATE=1:DRAW_BALANCER_RATE_BUTTONS
      IF BUT_PRESS = 13 THEN BB_SET_RATE=2:DRAW_BALANCER_RATE_BUTTONS
      IF BUT_PRESS = 14 THEN BB_SET_RATE=3:DRAW_BALANCER_RATE_BUTTONS
      IF BUT_PRESS = 15 THEN BB_SET_RATE=4:DRAW_BALANCER_RATE_BUTTONS
    ENDIF
  LOOP
  DRAW_MAIN
END SUB
  
SUB SHOW_BALANCER_STATE
  'new routine which simply echoes the Balancer's text status
  IF len(BB_STATUS)>0 THEN
    TEXT 0,30,LEFT$(BB_STATUS+PADDING,20),LT,8,1,FG_COL,BG_COL
  ELSE
    TEXT 0,30,"No Balancer comms.....",LT,8,1,ERROR_COL,BG_COL
  ENDIF
  'old routine which inferred state from data
  'LOCAL INTEGER D,N
  'IF BB_I(0) <>0 THEN
  '  N=1:D=BB_I(0)
  'ELSE IF BB_I(1) <>0 THEN
  '  N=2:D=BB_I(1)
  'ELSE IF BB_I(2) <>0 THEN
  '  N=3:D=BB_I(2)
  'ELSE IF BB_I(3) <>0 THEN
  '  N=4:D=BB_I(3)
  'ELSE
  '  TEXT 144,40,"  IDLE     ",LT,8,1,FG_COL,BG_COL
  '  EXIT SUB
  'ENDIF
  'IF D<0 THEN
  '  TEXT 144,40,"ST=>C"+STR$(N)+" "+STR$(abs(D),3,0)+"%",LT,8,1,FG_COL,BG_COL
  'ELSE
  '  TEXT 144,40,"C"+STR$(N)+"=>ST "+STR$(abs(D),3,0)+"%",LT,8,1,FG_COL,BG_COL
  'ENDIF
END SUB
  
SUB DRAW_BALANCER
  CLS(BG_COL)
  TEXT 160,5,"BALANCER CONTROL",CT,8,1,FG_COL,BG_COL
  D_BUT 0, 0, 245, 205, 70, 30, BUT_COL, "BACK"
  D_BUT 1, 0, 245, 100, 70, 30, BUT_COL, "PAUSE"
  D_BUT 2, 0, 245, 135, 70, 30, BUT_COL, "RESUME"
  D_BUT 3, 0, 245, 170, 70, 30, BUT_COL, "GRAPH"
  
  D_BUT 4, 0, 5, 100, 70, 30, BUT_COL, "C1=>ST"
  D_BUT 5, 0, 5, 135, 70, 30, BUT_COL, "C2=>ST"
  D_BUT 6, 0, 5, 170, 70, 30, BUT_COL, "C3=>ST"
  D_BUT 7, 0, 5, 205, 70, 30, BUT_COL, "C4=>ST"
  
  D_BUT 8, 0, 85, 100, 70, 30, BUT_COL, "ST=>C1"
  D_BUT 9, 0, 85, 135, 70, 30, BUT_COL, "ST=>C2"
  D_BUT 10, 0, 85, 170, 70, 30, BUT_COL, "ST=>C3"
  D_BUT 11, 0, 85, 205, 70, 30, BUT_COL, "ST=>C4"
  DRAW_BALANCER_RATE_BUTTONS
END SUB
  
SUB DRAW_BALANCER_RATE_BUTTONS
  LOCAL INTEGER C
  IF BB_SET_RATE<1 THEN BB_SET_RATE=1
  IF BB_SET_RATE>4 THEN BB_SET_RATE=4
  C=FADE_COL
  IF BB_SET_RATE = 1 THEN C=FG_COL
  D_BUT 12, 0, 165, 100, 70, 30, C, "25%"
  C=FADE_COL
  IF BB_SET_RATE = 2 THEN C=FG_COL
  D_BUT 13, 0, 165, 135, 70, 30, C, "50%"
  C=FADE_COL
  IF BB_SET_RATE = 3 THEN C=FG_COL
  D_BUT 14, 0, 165, 170, 70, 30, C, "75%"
  C=FADE_COL
  IF BB_SET_RATE = 4 THEN C=FG_COL
  D_BUT 15, 0, 165, 205, 70, 30, C, "100%"
END SUB
  
SUB BALANCER_GRAPH
  DRAW_BALANCER_GRAPH
  DO
    SAMPLE_MANAGER
    BUT_PRESS=CheckButtonPress(0,2)
    IF BUT_PRESS >= 0 THEN
      CheckButtonRelease(BUT_PRESS)
      IF BUT_PRESS = 0 THEN BUT_PRESS=-1:EXIT DO
      IF BUT_PRESS = 1 THEN DRAW_BALANCER_GRAPH
      IF BUT_PRESS = 2 THEN DRAW_B_V_GRAPH
    ENDIF
  LOOP
END SUB
  
SUB DRAW_BALANCER_GRAPH
  CLS
  LOCAL INTEGER X,S
  TEXT 160,5,"BALANCER HISTORY",CT,8,1,FG_COL,BG_COL
  D_BUT 0, 0, 215, 210, 100, 24, BUT_COL, "Back"
  D_BUT 1, 0,  110, 210, 100, 24, BUT_COL, "Refresh"
  D_BUT 2, 0,  5, 210, 100, 24, BUT_COL, "Cell V"
  DRAW_AXIS
  'axis labels
  TEXT A_R+2,A_T,"=>Cx",LT,1,1,A_COL,BG_COL
  TEXT A_R+2,A_B,"=>ST",LB,1,1,A_COL,BG_COL
  TEXT A_R+2,(A_T+A_B)\2,"%",LM,1,1,A_COL,BG_COL
  'trace labels (using I1-I4 colours)
  TEXT A_L-1,(A_T+A_B)\2-20,"C1",RM,,1,I1_COL,BG_COL
  TEXT A_L-1,(A_T+A_B)\2,"C2",RM,,1,I2_COL,BG_COL
  TEXT A_L-1,(A_T+A_B)\2+20,"C3",RM,,1,I3_COL,BG_COL
  TEXT A_L-1,(A_T+A_B)\2+40,"C4",RM,,1,I4_COL,BG_COL
  FOR I = 0 TO BB_SAMPLES -1
    X=(I*(A_R-A_L))/BB_SAMPLES+A_L
    S=(BB_S_PTR+I) MOD BB_SAMPLES
    PIXEL X,(BB_I_H(0,S)*(A_B-A_T)/200)+(A_T+A_B)\2,I1_COL
    PIXEL X+BB_D,(BB_I_H(1,S)*(A_B-A_T)/200)+(A_T+A_B)\2,I2_COL
    PIXEL X+BB_D*2,(BB_I_H(2,S)*(A_B-A_T)/200)+(A_T+A_B)\2,I3_COL
    PIXEL X+BB_D*3,(BB_I_H(3,S)*(A_B-A_T)/200)+(A_T+A_B)\2,I4_COL
  NEXT I
END SUB
  
SUB DRAW_B_V_GRAPH
  CLS
  LOCAL INTEGER X,Y,S,K
  LOCAL FLOAT VMID
  VMID=BB_V(1) 'current C1 voltage as baseline
  TEXT 160,5,"CELL V HISTORY",CT,8,1,FG_COL,BG_COL
  D_BUT 0, 0, 215, 210, 100, 24, BUT_COL, "Back"
  D_BUT 1, 0,  5, 210, 100, 24, BUT_COL, "Balance"
  D_BUT 2, 0,  110, 210, 100, 24, BUT_COL, "Refresh"
  DRAW_AXIS
  'axis labels
  TEXT A_R+2,A_T,STR$(VMID+0.5,2,1),LT,1,1,A_COL,BG_COL
  TEXT A_R+2,A_B,STR$(VMID-0.5,2,1),LB,1,1,A_COL,BG_COL
  TEXT A_R+2,(A_T+A_B)\2,STR$(VMID,2,1),LM,1,1,A_COL,BG_COL
  'trace labels (using I1-I4 colours)
  'TEXT A_L-1,(A_T+A_B)\2-40,"VST",RM,,1,V_COL,BG_COL
  TEXT A_L-1,(A_T+A_B)\2-20,"VC1",RM,,1,I1_COL,BG_COL
  TEXT A_L-1,(A_T+A_B)\2,"VC2",RM,,1,I2_COL,BG_COL
  TEXT A_L-1,(A_T+A_B)\2+20,"VC3",RM,,1,I3_COL,BG_COL
  TEXT A_L-1,(A_T+A_B)\2+40,"VC4",RM,,1,I4_COL,BG_COL
  FOR I = 0 TO BB_SAMPLES -1
    X=(I*(A_R-A_L))/BB_SAMPLES+A_L
    S=(BB_S_PTR+I) MOD BB_SAMPLES
    FOR K = 1 TO 4
      Y=((VMID-BB_V_H(K,S))*(A_B-A_T)*2+A_T+A_B)/2
      IF Y < A_T THEN Y = A_T
      IF Y > A_B THEN Y = A_B
      IF K = 1 THEN PIXEL X,Y,I1_COL
      IF K = 2 THEN PIXEL X+BB_D,Y,I2_COL
      IF K = 3 THEN PIXEL X+BB_D*2,Y,I3_COL
      IF K = 4 THEN PIXEL X+BB_D*3,Y,I4_COL
    NEXT K
  NEXT I
END SUB
  
SUB DRAW_AXIS
  'axis
  BOX 0,A_T,319,A_B-A_T+1,,BG_COL,BG_COL
  LINE A_L,A_T,A_R,A_T,1,A_COL
  LINE A_L,A_T,A_L,A_B,1,A_COL
  LINE A_L,A_B,A_R,A_B,1,A_COL
  LINE A_R,A_T,A_R,A_B,1,A_COL
  LINE A_L,(A_T+A_B)\2,A_R,(A_T+A_B)\2,1,A_COL
  TEXT A_R,A_B+2,"NOW",RT,1,1,A_COL,BG_COL
END SUB
  
SUB BALANCER_CMD(S AS STRING)
  PRINT #8,S+chr$(13);  'Balancer understands CR only
  'PRINT #8,S
END SUB
  
SUB SOFT_SWITCH_MENU
  DRAW_SOFT_SWITCH
  DO
    SAMPLE_MANAGER
    IF TRIG_TRIP>0 THEN DRAW_SOFT_SWITCH:TRIG_TRIP=0
    BUT_PRESS=CheckButtonPress(0, TRIG_COUNT*2)
    IF BUT_PRESS >= 0 THEN
      CheckButtonRelease(BUT_PRESS)
      IF BUT_PRESS>0 AND BUT_PRESS <= TRIG_COUNT THEN EDIT_SWITCH(BUT_PRESS-1)
      IF BUT_PRESS>TRIG_COUNT THEN
        IF TRIG_STATE(BUT_PRESS-TRIG_COUNT-1) > 0 THEN 'if tripped
          TRIG_STATE(BUT_PRESS-TRIG_COUNT-1)=0         'reset
          DRAW_SOFT_SWITCH
          TRIG_TRIP=0
        ELSE
          TRIG_SWITCH(BUT_PRESS-TRIG_COUNT-1)  'otherwise trigger
          DRAW_SOFT_SWITCH
          TRIG_TRIP=0
        ENDIF
      ENDIF
      IF BUT_PRESS = 0 THEN EXIT DO
    ENDIF
  LOOP
  DRAW_MAIN
END SUB
  
SUB DRAW_SOFT_SWITCH
  CLS(BG_COL)
  TEXT 120,5,"SOFT SWITCH",CT,8,1,FG_COL,BG_COL
  D_BUT 0, 0, 240, 5, 60, 30, BUT_COL, "BACK"
  FOR I = 0 to TRIG_COUNT-1  'data
    D_BUT I+1, 0, 10, 40+I*25, 60, 23, BUT_COL, "TR "+STR$(I)
    IF TRIG_STATE(I) > 0 THEN
      'TEXT 80,40+I*25,"TRIP",LT,8,1,BG_COL,ERROR_COL
      D_BUT I+1+TRIG_COUNT, 0, 80, 40+I*25, 60, 23, ERROR_COL, "TRIP"
    ELSE
      'TEXT 80,40+I*25," OK ",LT,8,1,BG_COL,OK_COL
      D_BUT I+1+TRIG_COUNT, 0, 80, 40+I*25, 60, 23, OK_COL, "OK"
    ENDIF
    TEXT 150,40+I*25,TRIG_COND(I),LT,8,1,FG_COL,BG_COL
    IF LEFT$(TRIG_COND(I),1)="V" THEN
      TEXT 200,40+I*25,STR$(TRIG_THRESH(I),3,2)+"V",LT,8,1,FG_COL,BG_COL
    ELSE IF LEFT$(TRIG_COND(I),1)="I" THEN
      TEXT 200,40+I*25,STR$(TRIG_THRESH(I),3,2)+"A",LT,8,1,FG_COL,BG_COL
    ELSE
      TEXT 200,40+I*25,"NOT SET",LT,8,1,FG_COL,BG_COL
    ENDIF
  NEXT I
END SUB
  
SUB EDIT_SWITCH(N AS INTEGER)
  DRAW_EDIT_SWITCH(N)
  DO
    SAMPLE_MANAGER
    IF TRIG_TRIP>0 THEN DRAW_EDIT_SWITCH(N):TRIG_TRIP=0
    BUT_PRESS=CheckButtonPress(0, 17)
    IF BUT_PRESS >= 0 THEN
      CheckButtonRelease(BUT_PRESS)
      IF BUT_PRESS = 0 THEN BUT_PRESS=-1: EXIT DO
      IF BUT_PRESS = 1 THEN TRIG_SWITCH(N):DRAW_EDIT_SWITCH(N)
      IF BUT_PRESS = 2 THEN TRIG_STATE(N)=0:DRAW_EDIT_SWITCH(N)
      IF BUT_PRESS >=3 AND BUT_PRESS <= 12 THEN
        TRIG_COND(N)=LEFT$(key_caption(BUT_PRESS),3)
        VAR SAVE TRIG_COND()
        DRAW_EDIT_SWITCH(N)
      ENDIF
      IF BUT_PRESS = 13 THEN TRIG_THRESH(N)=-NUMBERPAD("THRESHOLD (NEGATIVE)"):DRAW_EDIT_SWITCH(N)
      IF BUT_PRESS = 14 THEN TRIG_THRESH(N)=NUMBERPAD("THRESHOLD (POSITIVE)"):DRAW_EDIT_SWITCH(N)
      IF BUT_PRESS = 15 THEN TRIG_SET(N)=GET_BITMASK("SWITCH OUTPUTS",8,TRIG_SET(N)):DRAW_EDIT_SWITCH(N)
      IF BUT_PRESS = 16 THEN TRIG_CLEAR(N)=GET_BITMASK("RESET TRIGGERS",TRIG_COUNT,TRIG_CLEAR(N)):DRAW_EDIT_SWITCH(N)
      IF BUT_PRESS=17 THEN TRIG_COND(N)="   " :DRAW_EDIT_SWITCH(N)
    ENDIF
  LOOP
  VAR SAVE TRIG_COND(),TRIG_THRESH(),TRIG_SET(),TRIG_CLEAR()
  DRAW_SOFT_SWITCH
END SUB
  
SUB DRAW_EDIT_SWITCH(N AS INTEGER)
  LOCAL INTEGER DBYTE
  CLS(BG_COL)
  TEXT 120,5,"EDIT TRIGGER "+STR$(N),CT,8,1,FG_COL,BG_COL
  D_BUT 0, 0, 240, 5, 60, 30, BUT_COL, "BACK"
  D_BUT 1, 0, 10, 85, 60, 30, BUT_COL, "TRIP"
  D_BUT 2, 0, 10,125, 60, 30, BUT_COL, "RESET"
  
  D_BUT 3, 0, 10,165, 60, 30, BUT_COL, "V <"
  D_BUT 4, 0, 10,205, 60, 30, BUT_COL, "V >"
  
  D_BUT 5, 0, 80, 85, 60, 30, BUT_COL, "I1<"
  D_BUT 6, 0,150, 85, 60, 30, BUT_COL, "I1>"
  
  D_BUT 7, 0, 80,125, 60, 30, BUT_COL, "I2<"
  D_BUT 8, 0,150,125, 60, 30, BUT_COL, "I2>"
  
  D_BUT 9, 0, 80,165, 60, 30, BUT_COL, "I3<"
  D_BUT 10,0,150,165, 60, 30, BUT_COL, "I3>"
  
  D_BUT 11,0, 80,205, 60, 30, BUT_COL, "I4<"
  D_BUT 12,0,150,205, 60, 30, BUT_COL, "I4>"
  
  D_BUT 13,0,220, 85, 90, 30, BUT_COL, "THRESHOLD-"
  D_BUT 14,0,220,125, 90, 30, BUT_COL, "THRESHOLD+"
  D_BUT 15,0,220,165, 90, 30, BUT_COL, "SWITCHES"
  D_BUT 16,0,220,205, 90, 30, BUT_COL, "RESETS"
  D_BUT 17,0, 10, 45, 60, 30, BUT_COL, "CLEAR"
  
  IF TRIG_STATE(N) > 0 THEN
    TEXT 80,40,"TRIP",LT,8,1,BG_COL,ERROR_COL
  ELSE
    TEXT 80,40," OK ",LT,8,1,BG_COL,OK_COL
  ENDIF
  TEXT 150,40,TRIG_COND(N),LT,8,1,FG_COL,BG_COL
  IF LEFT$(TRIG_COND(N),1)="V" THEN
    TEXT 200,40,STR$(TRIG_THRESH(N),3,2)+"V",LT,8,1,FG_COL,BG_COL
  ELSE IF LEFT$(TRIG_COND(N),1)="I" THEN
    TEXT 200,40,STR$(TRIG_THRESH(N),3,2)+"A",LT,8,1,FG_COL,BG_COL
  ELSE
    TEXT 200,40,"NOT SET",LT,8,1,FG_COL,BG_COL
  ENDIF
  TEXT 75,68,"S",LT,1,1,FG_COL,BG_COL
  DBYTE=1
  FOR I = 0 TO 7' switch outputs
    IF (DBYTE AND TRIG_SET(N))>0 THEN
      TEXT 85+I*10,68,STR$(I),LT,1,1,OK_COL,BG_COL
    ELSE
      TEXT 85+I*10,68,STR$(I),LT,1,1,ERROR_COL,BG_COL
    ENDIF
    DBYTE=DBYTE+DBYTE
  NEXT I
  TEXT 180,68,"R",LT,1,1,FG_COL,BG_COL
  DBYTE=1
  FOR I = 0 TO TRIG_COUNT-1' reset flags
    IF (DBYTE AND TRIG_CLEAR(N))>0 THEN
      TEXT 190+I*10,68,STR$(I),LT,1,1,OK_COL,BG_COL
    ELSE
      TEXT 190+I*10,68,STR$(I),LT,1,1,ERROR_COL,BG_COL
    ENDIF
    DBYTE=DBYTE+DBYTE
  NEXT I
END SUB
  
FUNCTION GET_BITMASK(P AS STRING, N AS INTEGER, L AS INTEGER) AS INTEGER  'n is number of bits, p is prompt, L is preload (ie old state)
  GET_BITMASK=L
  DRAW_GET_BITMASK(P,N,GET_BITMASK)
  DO
    SAMPLE_MANAGER
    BUT_PRESS=CheckButtonPress(0, N*2)
    IF BUT_PRESS >= 0 THEN
      CheckButtonRelease(BUT_PRESS)
      IF BUT_PRESS = 0 THEN BUT_PRESS=-1: EXIT DO
      IF BUT_PRESS > 0 THEN GET_BITMASK=BIT_CHANGE(GET_BITMASK,BUT_PRESS):DRAW_GET_BITMASK(P,N,GET_BITMASK)
    ENDIF
  LOOP
END FUNCTION
  
SUB DRAW_GET_BITMASK(P AS STRING, N AS INTEGER, L AS INTEGER)
  LOCAL INTEGER DBYTE
  CLS(BG_COL)
  TEXT 120,5,P,CT,8,1,FG_COL,BG_COL
  D_BUT 0, 0, 240, 5, 60, 30, BUT_COL, "DONE"
  DBYTE=1
  FOR I = 0 TO N-1
    D_BUT I*2+1, 0, I*40, 80, 35, 35, BUT_COL, "ON"
    D_BUT I*2+2, 0, I*40,160, 35, 35, BUT_COL, "OFF"
    TEXT I*40+10,125,STR$(I),LT,8,1,FG_COL,BG_COL
    IF (L AND DBYTE)>0 THEN
      TEXT I*40+10,205,"1",LT,8,1,OK_COL,BG_COL
    ELSE
      TEXT I*40+10,205,"0",LT,8,1,ERROR_COL,BG_COL
    ENDIF
    DBYTE=DBYTE+DBYTE '<<1
  NEXT I
END SUB
  
FUNCTION BIT_CHANGE(N AS INTEGER, B AS INTEGER) AS INTEGER      ''alters N as per button B
  BIT_CHANGE=N
  LOCAL INTEGER A,C
  A=(B MOD 2) 'set/clear
  C=2^((B-1)\2) 'bit mask
  IF A>0 THEN
    BIT_CHANGE=BIT_CHANGE OR C
  ELSE
    BIT_CHANGE=BIT_CHANGE AND (65535-C) 'up to 16
  ENDIF
END FUNCTION
  
SUB TRIG_SWITCH(N AS INTEGER)
  LOCAL INTEGER DBYTE,I
  'trip state
  TRIG_STATE(N)=1
  'PRINT "TRIGGER:";N
  ''toggle control lines
  I2C OPEN 100,100
  DBYTE=255-(TRIG_SET(N) AND 255) 'active low
  I2C WRITE IO_ADDR,0,1,DBYTE
  PAUSE 10
  DBYTE=255
  I2C WRITE IO_ADDR,0,1,DBYTE
  I2C CLOSE
  DBYTE =1
  'clear as needed
  FOR I = 0 TO TRIG_COUNT-1
    IF (DBYTE AND TRIG_CLEAR(N)) > 0 THEN TRIG_STATE(I)=0:'PRINT "RESET:";I
    DBYTE=DBYTE+DBYTE '<<1
  NEXT I
  'save everything
  VAR SAVE TRIG_COND(),TRIG_THRESH(),TRIG_SET(),TRIG_CLEAR()
  TRIG_TRIP=1 'flag that something has changed asynchronously
ENd SUB
  
SUB CHECK_TRIGGERS  ''called when samples finished
  'PRINT "CHECKING TRIGGERS"
  LOCAL INTEGER I
  IF RAW_ACTUAL(1)<0 THEN EXIT SUB  'no valid data
  FOR I = 0 TO TRIG_COUNT-1
    IF TRIG_STATE(I)<1 THEN 'only if not tripped already
      IF LEFT$(TRIG_COND(I),1)="V" OR LEFT$(TRIG_COND(I),1)="I" THEN PARSE_TRIGGER(I)
    ENDIF
  NEXT I
END SUB
  
SUB PARSE_TRIGGER(T AS INTEGER)
  LOCAL INTEGER X
  X=0
  IF LEFT$(TRIG_COND(T),1)="V" THEN X=1 'index into actual()
  IF LEFT$(TRIG_COND(T),2)="I1" THEN X=2
  IF LEFT$(TRIG_COND(T),2)="I2" THEN X=3
  IF LEFT$(TRIG_COND(T),2)="I3" THEN X=4
  IF LEFT$(TRIG_COND(T),2)="I4" THEN X=5
  IF X<1 OR X>5 THEN EXIT SUB
  IF RIGHT$(TRIG_COND(T),1)="<" THEN
    IF ACTUAL(X)<TRIG_THRESH(T) THEN TRIG_SWITCH(T) :' PRINT "PARSE:";T
  ENDIF
  IF RIGHT$(TRIG_COND(T),1)=">" THEN
    IF ACTUAL(X)>TRIG_THRESH(T) THEN TRIG_SWITCH(T) :' PRINT "PARSE:";T
  ENDIF
END SUB
  
SUB CALIBRATE_MENU
  DRAW_CALIBRATE
  DO
    SAMPLE_MANAGER
    BUT_PRESS=CheckButtonPress(0, 5)
    IF BUT_PRESS >= 0 THEN
      CheckButtonRelease(BUT_PRESS)
      IF BUT_PRESS = 0 THEN  'volts
        IF OK_CANCEL_BOX("ENSURE NO LOAD","ON TERMINALS")>0 THEN DO_V_CAL
        DRAW_CALIBRATE       'return
      ENDIF
      IF (BUT_PRESS >=1) AND (BUT_PRESS <=4) THEN  'I1
        DO_I_CAL(BUT_PRESS)
        DRAW_CALIBRATE       'return
      ENDIF
      IF BUT_PRESS = 5 THEN EXIT DO
    ENDIF
  LOOP
  DRAW_MAIN
END SUB
  
SUB SETTINGS_MENU
  DRAW_SETTINGS
  LOCAL FLOAT NUM
  DO
    TEXT 160,30,"   "+DATE$+" "+TIME$+"   ",CT,1,1,FG_COL,BG_COL
    SAMPLE_MANAGER
    BUT_PRESS=CheckButtonPress(0, 13)
    IF BUT_PRESS >= 0 THEN
      CheckButtonRelease(BUT_PRESS)
      IF BUT_PRESS = 0 THEN  'year
        NUM=NUMBERPAD("Enter year:")
        IF NUM >= 2000 THEN SET_RTC(0,NUM)
        DRAW_SETTINGS       'return
      ENDIF
      IF BUT_PRESS = 1 THEN  'month
        NUM=NUMBERPAD("Enter month:")
        IF (NUM >= 1) AND (NUM <= 12) THEN SET_RTC(1,NUM)
        DRAW_SETTINGS       'return
      ENDIF
      IF BUT_PRESS = 2 THEN  'day
        NUM=NUMBERPAD("Enter day number:")
        IF (NUM >= 1) AND (NUM <= 31) THEN SET_RTC(2,NUM)
        DRAW_SETTINGS       'return
      ENDIF
      IF BUT_PRESS = 3 THEN  'hour
        NUM=NUMBERPAD("Enter hour (24):")
        IF (NUM >= 1) AND (NUM <= 24) THEN SET_RTC(3,NUM)
        DRAW_SETTINGS       'return
      ENDIF
      IF BUT_PRESS = 4 THEN  'minute
        NUM=NUMBERPAD("Enter minute:")
        IF (NUM >= 1) AND (NUM <= 60) THEN SET_RTC(4,NUM)
        DRAW_SETTINGS       'return
      ENDIF
      IF BUT_PRESS = 5 THEN  'second
        NUM=NUMBERPAD("Enter second:")
        IF (NUM >= 1) AND (NUM <= 60) THEN SET_RTC(5,NUM)
        DRAW_SETTINGS       'return
      ENDIF
      IF BUT_PRESS = 6 THEN  'BL full
        NUM=NUMBERPAD("Enter Backlight%:")
        IF (NUM >= 1) AND (NUM <= 100) THEN ON_BL=NUM:SET_BACKLIGHT(ON_BL):VAR SAVE ON_BL
        DRAW_SETTINGS       'return
      ENDIF
      IF BUT_PRESS = 9 THEN  'BL dim
        NUM=NUMBERPAD("Enter Backlight%:")
        IF (NUM >= 1) AND (NUM <= 100) THEN IDLE_BL=NUM:VAR SAVE IDLE_BL
        DRAW_SETTINGS       'return
      ENDIF
      IF BUT_PRESS = 8 THEN  'BL timeout
        NUM=NUMBERPAD("Enter timeout(s):")
        IF (NUM*1000 > IDLE_TOUT) THEN MN_TMOUT=NUM*1000-IDLE_TOUT : VAR SAVE MN_TMOUT
        DRAW_SETTINGS       'return
      ENDIF
      IF BUT_PRESS = 7 THEN  'Vfull
        NUM=NUMBERPAD("Enter V(full):")
        IF (NUM>=5) AND (NUM>V_EMPTY) AND (NUM>V_SHUTDOWN) THEN
          V_FULL=NUM
          VAR SAVE V_FULL
        ELSE
          MessageBox("V(full) too low","Check and retry")
        ENDIF
        DRAW_SETTINGS       'return
      ENDIF
      IF BUT_PRESS = 10 THEN  'Vempty
        NUM=NUMBERPAD("Enter V(empty):")
        IF (NUM>=5) AND (NUM<V_FULL) AND (NUM>V_SHUTDOWN) THEN
          V_EMPTY=NUM
          VAR SAVE V_EMPTY
        ELSE
          MessageBox("V(empty) too low","or above V(full)")
        ENDIF
        DRAW_SETTINGS       'return
      ENDIF
      IF BUT_PRESS = 12 THEN  'Iscale
        NUM=NUMBERPAD("Enter I(scale):")
        IF (NUM>=1) THEN
          I_SCALE=NUM
          VAR SAVE I_SCALE
        ELSE
          MessageBox("I(scale)","too low")
        ENDIF
        DRAW_SETTINGS       'return
      ENDIF
      IF BUT_PRESS = 13 THEN  'Vshutdown
        NUM=NUMBERPAD("Enter V(shutdown):")
        IF ((NUM >= 0) AND (NUM<V_EMPTY)) THEN
          V_SHUTDOWN=NUM
          VAR SAVE V_SHUTDOWN
        ELSE
          MessageBox("V(shutdown)","too high")
        ENDIF
        DRAW_SETTINGS       'return
      ENDIF
      IF BUT_PRESS = 11 THEN EXIT DO 'back
    ENDIF
  LOOP
  DRAW_MAIN
END SUB
  
SUB SET_RTC(S AS INTEGER, P AS INTEGER) '' sets parameter s to p (y=0,m=1,d=2,h=3,m=4,s=5) as per RTC SETTIME
  LOCAL INTEGER T(6)
  T(0)=val(mid$(DATE$,7,4)) 'year
  T(1)=val(mid$(DATE$,4,2)) 'month
  T(2)=val(mid$(DATE$,1,2)) 'day
  T(3)=val(mid$(TIME$,1,2)) 'hour/24
  T(4)=val(mid$(TIME$,4,2)) 'minute
  T(5)=val(mid$(TIME$,7,2)) 'second
  IF (S>=0) AND (S<=5) THEN T(S)=P'validation must occur before calling
  ON ERROR IGNORE
  RTC SETTIME T(0),T(1),T(2),T(3),T(4),T(5)
  ON ERROR ABORT
END SUB
  
SUB DATA_MENU
  LOCAL INTEGER GRAPH_MODE
  LOCAL INTEGER UPDATE_TIME
  UPDATE_TIME=TIMER
  GRAPH_MODE=0
  DRAW_DATA
  DRAW_GRAPH(GRAPH_MODE)
  DO
    SAMPLE_MANAGER
    BUT_PRESS=CheckButtonPress(0, 4)
    IF BUT_PRESS >= 0 THEN
      CheckButtonRelease(BUT_PRESS)
      IF BUT_PRESS < 3 THEN GRAPH_MODE=BUT_PRESS: DRAW_GRAPH(GRAPH_MODE): UPDATE_TIME=TIMER
      IF BUT_PRESS = 3 THEN EXIT DO
      IF BUT_PRESS = 4 THEN EXPORT_DATA(GRAPH_MODE)
    ENDIF
    'check for touches on scale and display
    IF (TIMER - UPDATE_TIME) > 60000 THEN DRAW_GRAPH(GRAPH_MODE): UPDATE_TIME=TIMER   ''update every minute
  LOOP
  DRAW_MAIN
END SUB
  
SUB DRAW_GRAPH(N AS INTEGER)  ''0=hours, 1=days, 2=weeks
  LOCAL INTEGER I
  ''clear chart area
  ''axes
  DRAW_AXIS
  ''right labels
  TEXT A_R+2,A_T,STR$(V_FULL, 2, 1),LT,,1,V_COL,BG_COL
  TEXT A_R+2,A_B,STR$(V_EMPTY, 2, 1),LB,,1,V_COL,BG_COL
  TEXT A_R+2,(A_T+A_B)\2,"V",LM,,1,V_COL,BG_COL
  ''left labels
  TEXT A_L-1,A_T,STR$(I_SCALE, 2,0),RT,,1,I2_COL,BG_COL
  TEXT A_L-1,A_B,STR$(-I_SCALE, 2,0),RB,,1,I2_COL,BG_COL
  TEXT A_L-1,(A_T+A_B)\2-20,"I1",RM,,1,I1_COL,BG_COL
  TEXT A_L-1,(A_T+A_B)\2,"I2",RM,,1,I2_COL,BG_COL
  TEXT A_L-1,(A_T+A_B)\2+20,"I3",RM,,1,I3_COL,BG_COL
  TEXT A_L-1,(A_T+A_B)\2+40,"I4",RM,,1,I4_COL,BG_COL
  ''bottom labels
  IF N = 0 THEN
    TEXT A_L,A_B+2,"-60 minutes",LT,,1,A_COL,BG_COL
    FOR I = 0 to S_COUNT-1
      ''heaps of data points, so just draw dots
      IF SAMPLES(1,((SAMPLE_STATE+I+1) MOD 720))>0 THEN 'valid data
        DRAW_SAMPLE_PIXELS(A_L+((A_R-A_L)*I)\S_COUNT,((SAMPLE_STATE+I+1) MOD 720))
      END IF
    NEXT I
  ENDIF
  IF N = 1 THEN
    TEXT A_L,A_B+2,"-48 hours  ",LT,,1,A_COL,BG_COL
    DRAW_HOUR_LINES
  ENDIF
  IF N = 2 THEN
    TEXT A_L,A_B+2,STR$(-D_COUNT)+" days    ",LT,,1,A_COL,BG_COL
    DRAW_DAY_LINES
  ENDIF
END SUB
  
SUB DRAW_HOUR_LINES
  LOCAL INTEGER I,J
  LOCAL INTEGER X(H_COUNT),Y(6,H_COUNT)
  FOR I = 0 to H_COUNT-1
    ''calc y values
    IF H_SAMP(1,I) > 0 THEN
      Y(1,I)=A_B+(H_SAMP(1,I)-V_EMPTY)*(A_B-A_T)/(V_EMPTY-V_FULL)
      IF Y(1,I) < A_T+1 THEN Y(1,I) = A_T+1
      IF Y(1,I) > A_B-1 THEN Y(1,I) = A_B-1
      FOR J = 2 to 5  ''current values
        Y(J,I)=(A_B+A_T)\2 + H_SAMP(J,I)*(A_B-A_T)/(2*I_SCALE)
        IF Y(J,I) < A_T+1 THEN Y(J,I) = A_T+1
        IF Y(J,I) > A_B-1 THEN Y(J,I) = A_B-1
      NEXT J
    ENDIF
    ''calc x values
    X(I)= A_L + ((I + H_COUNT - H_PTR)*(A_R-A_L))/H_COUNT-1
    IF (X(I) < A_L) OR (X(I) > A_R) THEN X(I)=0  ''not valid
  NEXT I
  ''draw lines
  FOR I = 0 to H_COUNT-2
    IF (X(I)>0) AND (X(I+1)>0) AND (Y(1,I)>0)AND (Y(1,I+1)>0) THEN
      LINE X(I),Y(1,I),X(I+1),Y(1,I+1),1,V_COL
      LINE X(I),Y(2,I),X(I+1),Y(2,I+1),1,I1_COL
      LINE X(I),Y(3,I),X(I+1),Y(3,I+1),1,I2_COL
      LINE X(I),Y(4,I),X(I+1),Y(4,I+1),1,I3_COL
      LINE X(I),Y(5,I),X(I+1),Y(5,I+1),1,I4_COL
    ENDIF
  NEXT I
END SUB
  
SUB DRAW_DAY_LINES
  LOCAL INTEGER I,J
  LOCAL INTEGER X(D_COUNT),Y(6,D_COUNT)
  FOR I = 0 to D_COUNT-1
    ''calc y values
    IF D_SAMP(1,I) > 0 THEN
      Y(1,I)=A_B+(D_SAMP(1,I)-V_EMPTY)*(A_B-A_T)/(V_EMPTY-V_FULL)
      IF Y(1,I) < A_T+1 THEN Y(1,I) = A_T+1
      IF Y(1,I) > A_B-1 THEN Y(1,I) = A_B-1
      FOR J = 2 to 5  ''current values
        Y(J,I)=(A_B+A_T)\2 + D_SAMP(J,I)*(A_B-A_T)/(2*I_SCALE)
        IF Y(J,I) < A_T+1 THEN Y(J,I) = A_T+1
        IF Y(J,I) > A_B-1 THEN Y(J,I) = A_B-1
      NEXT J
    ENDIF
    ''calc x values
    X(I)= A_L + ((I + D_COUNT - D_PTR)*(A_R-A_L))/D_COUNT-1
    IF (X(I) < A_L) OR (X(I) > A_R) THEN X(I)=0  ''not valid
  NEXT I
  ''draw lines
  FOR I = 0 to D_COUNT-2
    IF (X(I)>0) AND (X(I+1)>0) AND (Y(1,I)>0)AND (Y(1,I+1)>0) THEN
      LINE X(I),Y(1,I),X(I+1),Y(1,I+1),1,V_COL
      LINE X(I),Y(2,I),X(I+1),Y(2,I+1),1,I1_COL
      LINE X(I),Y(3,I),X(I+1),Y(3,I+1),1,I2_COL
      LINE X(I),Y(4,I),X(I+1),Y(4,I+1),1,I3_COL
      LINE X(I),Y(5,I),X(I+1),Y(5,I+1),1,I4_COL
    ENDIF
  NEXT I
END SUB
  
SUB DRAW_SAMPLE_PIXELS(X AS INTEGER,N AS INTEGER) ''x coord, sample #
  LOCAL INTEGER Y
  ''data is validated already
  'V:
  Y=A_B+(SAMPLES(1,N)-V_EMPTY)*(A_B-A_T)/(V_EMPTY-V_FULL)
  IF Y < A_T+1 THEN Y = A_T+1
  IF Y > A_B-1 THEN Y = A_B-1
  PIXEL X,Y,V_COL
  ''I1:
  Y=(A_B+A_T)\2 + SAMPLES(2,N)*(A_B-A_T)/(2*I_SCALE)
  IF Y < A_T+1 THEN Y = A_T+1
  IF Y > A_B-1 THEN Y = A_B-1
  PIXEL X,Y,I1_COL
  ''I2:
  Y=(A_B+A_T)\2 + SAMPLES(3,N)*(A_B-A_T)/(2*I_SCALE)
  IF Y < A_T+1 THEN Y = A_T+1
  IF Y > A_B-1 THEN Y = A_B-1
  PIXEL X,Y,I2_COL
  ''I3:
  Y=(A_B+A_T)\2 + SAMPLES(4,N)*(A_B-A_T)/(2*I_SCALE)
  IF Y < A_T+1 THEN Y = A_T+1
  IF Y > A_B-1 THEN Y = A_B-1
  PIXEL X,Y,I3_COL
  ''I4:
  Y=(A_B+A_T)\2 + SAMPLES(5,N)*(A_B-A_T)/(2*I_SCALE)
  IF Y < A_T+1 THEN Y = A_T+1
  IF Y > A_B-1 THEN Y = A_B-1
  PIXEL X,Y,I4_COL
END SUB
  
SUB EXPORT_DATA(N AS INTEGER)  ''0=hours, 1=days, 2=weeks
  IF N = 0 THEN EXPORT_HOURS
  IF N = 1 THEN EXPORT_DAYS
  IF N = 2 THEN EXPORT_WEEKS
END SUB
  
SUB EXPORT_HOURS
  LOCAL INTEGER I
  local INTEGER START_TIME
  START_TIME = (TIME_SERIAL()\5)*5-3600 '1 hour ago, round to 5s
  PRINT "Silicon Chip Battery Manager Hours Data Export"
  PRINT "Time,Voltage(V),Current 1 (A),Current 2 (A),Current 3 (A),Current 4 (A)"
  FOR I = 0 to S_COUNT-1
    IF SAMPLES(1,((SAMPLE_STATE+I+1) MOD 720))>0 THEN 'valid data
      PRINT DATE_TIME_STRING(START_TIME+I*5);",";
      PRINT STR$(SAMPLES(1,((SAMPLE_STATE+I+1) MOD 720)));",";
      PRINT STR$(SAMPLES(2,((SAMPLE_STATE+I+1) MOD 720)));",";
      PRINT STR$(SAMPLES(3,((SAMPLE_STATE+I+1) MOD 720)));",";
      PRINT STR$(SAMPLES(4,((SAMPLE_STATE+I+1) MOD 720)));",";
      PRINT STR$(SAMPLES(5,((SAMPLE_STATE+I+1) MOD 720)))
    ENDIF
  NEXT I
END SUB
  
SUB EXPORT_DAYS
  LOCAL INTEGER I
  local INTEGER START_TIME
  START_TIME = H_START*3600 'hour
  PRINT "Silicon Chip Battery Manager Days Data Export"
  PRINT "Time,Voltage(V),Current 1 (A),Current 2 (A),Current 3 (A),Current 4 (A)"
  FOR I = 0 to H_COUNT-1
    IF H_SAMP(1,I)>0 THEN 'valid data
      PRINT DATE_TIME_STRING(START_TIME+I*3600);",";
      PRINT STR$(H_SAMP(1,I));",";
      PRINT STR$(H_SAMP(2,I));",";
      PRINT STR$(H_SAMP(3,I));",";
      PRINT STR$(H_SAMP(4,I));",";
      PRINT STR$(H_SAMP(5,I))
    ENDIF
  NEXT I
END SUB
  
SUB EXPORT_WEEKS
  LOCAL INTEGER I
  local INTEGER START_TIME
  START_TIME = D_START*86400 'days
  PRINT "Silicon Chip Battery Manager Weeks Data Export"
  PRINT "Time,Voltage(V),Current 1 (A),Current 2 (A),Current 3 (A),Current 4 (A)"
  FOR I = 0 to D_COUNT-1
    IF D_SAMP(1,I)>0 THEN 'valid data
      PRINT DATE_TIME_STRING(START_TIME+I*86400);",";
      PRINT STR$(D_SAMP(1,I));",";
      PRINT STR$(D_SAMP(2,I));",";
      PRINT STR$(D_SAMP(3,I));",";
      PRINT STR$(D_SAMP(4,I));",";
      PRINT STR$(D_SAMP(5,I))
    ENDIF
  NEXT I
END SUB
  
FUNCTION DATE_TIME_STRING (T AS INTEGER) AS STRING
  'tweak this to suit your preferred display format
  'Excel format serial number
  DATE_TIME_STRING = STR$(T\86400,6,0)+"."+STR$((((T MOD 86400)*1000000)\86400),6,0,"0")
END FUNCTION
  
SUB DO_I_CAL(I_NUM AS INTEGER)
  LOCAL I_ENTERED AS FLOAT
  LOCAL NEW_CAL AS FLOAT
  LOCAL ACTUAL_NOW AS FLOAT  'temp as this may change
  ACTUAL_NOW=abs(ACTUAL(I_NUM+1))
  IF ABS(ACTUAL_NOW) < 0.00001 THEN MessageBox("I TOO LOW","Check and retry") : EXIT SUB
  CLS(BG_COL)
  IF RAW_ACTUAL(1) < 800000 THEN MessageBox("INPUT V TOO LOW","Check and retry") : EXIT SUB
  I_ENTERED=NUMBERPAD("Enter I(A)")
  IF I_ENTERED < 0.000001 THEN EXIT SUB   'cancel
  NEW_CAL = I_ENTERED/ACTUAL_NOW
  TEXT 160,10,"New I("+STR$(I_NUM)+") factor:",CT,8,1,FG_COL,BG_COL
  TEXT 160,40,"I factor:",RT,1,1,FG_COL,BG_COL
  TEXT 160,40,STR$(NEW_CAL),LT,1,1,FG_COL,BG_COL
  IF OK_CANCEL_BUTTONS() > 0 THEN
    ''accept and store values
    I_CAL(I_NUM)=-NEW_CAL
    VAR SAVE I_CAL()
  ENDIF
END SUB
  
SUB DO_V_CAL
  LOCAL V_ENTERED AS FLOAT
  LOCAL ACTUAL_NOW(5) AS FLOAT  'temp as these may change
  LOCAL NEW_CAL(5) AS FLOAT
  LOCAL NEW_MIN,NEW_MAX AS FLOAT
  CLS(BG_COL)
  ACTUAL_NOW(1)=RAW_ACTUAL(1) ''mapping
  ACTUAL_NOW(2)=RAW_ACTUAL(3)
  ACTUAL_NOW(3)=RAW_ACTUAL(4)
  ACTUAL_NOW(4)=RAW_ACTUAL(5)
  ''check if valid, this will also trap /0 error
  IF ACTUAL_NOW(1) < 800000 THEN MessageBox("INPUT V TOO LOW","Check and retry") : EXIT SUB
  IF ACTUAL_NOW(2) < 800000 THEN MessageBox("INPUT V TOO LOW","Check and retry") : EXIT SUB
  IF ACTUAL_NOW(3) < 800000 THEN MessageBox("INPUT V TOO LOW","Check and retry") : EXIT SUB
  IF ACTUAL_NOW(4) < 800000 THEN MessageBox("INPUT V TOO LOW","Check and retry") : EXIT SUB
  V_ENTERED=NUMBERPAD("Enter Voltage")
  IF V_ENTERED < 5.0 THEN MessageBox("ENTERED V TOO LOW","Check and retry") : EXIT SUB   'cancel
  NEW_CAL(1)=V_ENTERED/ACTUAL_NOW(1)
  ''old method
  'NEW_CAL(2)=V_ENTERED/ACTUAL_NOW(2)
  'NEW_CAL(3)=V_ENTERED/ACTUAL_NOW(3)
  'NEW_CAL(4)=V_ENTERED/ACTUAL_NOW(4)
  ''new method
  NEW_CAL(2)=NEW_CAL(1)*I_RATIO(2)
  NEW_CAL(3)=NEW_CAL(1)*I_RATIO(3)
  NEW_CAL(4)=NEW_CAL(1)*I_RATIO(4)
  NEW_MIN=NEW_CAL(1)
  IF NEW_CAL(2)<NEW_MIN THEN NEW_MIN=NEW_CAL(2)
  IF NEW_CAL(3)<NEW_MIN THEN NEW_MIN=NEW_CAL(3)
  IF NEW_CAL(4)<NEW_MIN THEN NEW_MIN=NEW_CAL(4)
  NEW_MAX=NEW_CAL(1)
  IF NEW_CAL(2)>NEW_MAX THEN NEW_MAX=NEW_CAL(2)
  IF NEW_CAL(3)>NEW_MAX THEN NEW_MAX=NEW_CAL(3)
  IF NEW_CAL(4)>NEW_MAX THEN NEW_MAX=NEW_CAL(4)
  CLS(BG_COL)
  TEXT 160,10,"New V factors:",CT,8,1,FG_COL,BG_COL
  TEXT 160,40,"V1 factor:",RT,1,1,FG_COL,BG_COL
  TEXT 160,60,"V2 factor:",RT,1,1,FG_COL,BG_COL
  TEXT 160,80,"V3 factor:",RT,1,1,FG_COL,BG_COL
  TEXT 160,100,"V4 factor:",RT,1,1,FG_COL,BG_COL
  TEXT 160,120,"Variation:",RT,1,1,FG_COL,BG_COL
  TEXT 160,40,STR$(NEW_CAL(1)),LT,1,1,FG_COL,BG_COL
  TEXT 160,60,STR$(NEW_CAL(2)),LT,1,1,FG_COL,BG_COL
  TEXT 160,80,STR$(NEW_CAL(3)),LT,1,1,FG_COL,BG_COL
  TEXT 160,100,STR$(NEW_CAL(4)),LT,1,1,FG_COL,BG_COL
  TEXT 160,120,STR$(((NEW_MAX-NEW_MIN)*100)/NEW_MAX)+"%",LT,1,1,FG_COL,BG_COL
  ''check before saving
  IF OK_CANCEL_BUTTONS() > 0 THEN
    ''accept and store values
    V_CAL(1)=NEW_CAL(1)
    V_CAL(2)=NEW_CAL(2)
    V_CAL(3)=NEW_CAL(3)
    V_CAL(4)=NEW_CAL(4)
    VAR SAVE V_CAL()
  ENDIF
END SUB
  
SUB DRAW_CALIBRATE
  CLS(BG_COL)
  TEXT 160,10,"CALIBRATE",CT,8,1,FG_COL,BG_COL
  TEXT 160,40,"V factor:",RT,1,1,FG_COL,BG_COL
  TEXT 160,60,"I1 factor:",RT,1,1,FG_COL,BG_COL
  TEXT 160,80,"I2 factor:",RT,1,1,FG_COL,BG_COL
  TEXT 160,100,"I3 factor:",RT,1,1,FG_COL,BG_COL
  TEXT 160,120,"I4 factor:",RT,1,1,FG_COL,BG_COL
  
  TEXT 160,40,STR$(V_CAL(1)),LT,1,1,FG_COL,BG_COL
  TEXT 160,60,STR$(I_CAL(1)),LT,1,1,FG_COL,BG_COL
  TEXT 160,80,STR$(I_CAL(2)),LT,1,1,FG_COL,BG_COL
  TEXT 160,100,STR$(I_CAL(3)),LT,1,1,FG_COL,BG_COL
  TEXT 160,120,STR$(I_CAL(4)),LT,1,1,FG_COL,BG_COL
  
  D_BUT 0, 0, 20, 140, 80, 40, BUT_COL, "Volts"
  D_BUT 1, 0, 120, 140, 80, 40, BUT_COL, "Current 1"
  D_BUT 2, 0, 220, 140, 80, 40, BUT_COL, "Current 2"
  D_BUT 3, 0, 20, 190, 80, 40, BUT_COL, "Current 3"
  D_BUT 4, 0, 120, 190, 80, 40, BUT_COL, "Current 4"
  D_BUT 5, 0, 220, 190, 80, 40, BUT_COL, "Back"
END SUB
  
SUB DRAW_SETTINGS
  CLS(BG_COL)
  TEXT 160,5,"SETTINGS",CT,8,1,FG_COL,BG_COL
  D_BUT 0, 0, 20, 45, 80, 25, BUT_COL, "Year"
  D_BUT 1, 0, 120, 45, 80, 25, BUT_COL, "Month"
  D_BUT 2, 0, 220, 45, 80, 25, BUT_COL, "Day"
  D_BUT 3, 0, 20, 75, 80, 25, BUT_COL, "Hour"
  D_BUT 4, 0, 120, 75, 80, 25, BUT_COL, "Minute"
  D_BUT 5, 0, 220, 75, 80, 25, BUT_COL, "Second"
  D_BUT 6, 0, 20, 105, 80, 25, BUT_COL, "B/L"
  D_BUT 7, 0, 120, 105, 80, 25, BUT_COL, "V(Full)"
  D_BUT 8, 0, 220, 105, 80, 25, BUT_COL, "Timeout"
  D_BUT 9, 0, 20, 150, 80, 25, BUT_COL, "B/L (dim)"
  D_BUT 10, 0, 120, 150, 80, 25, BUT_COL,"V(empty)"
  D_BUT 12, 0, 20, 195, 80, 25, BUT_COL, "I scale"  'these were added later
  D_BUT 13, 0, 120, 195, 80, 25, BUT_COL,"V(sdown)" 'these were added later
  D_BUT 11, 0, 220, 150, 80, 70, BUT_COL, "BACK"
  TEXT 60,132,STR$(ON_BL)+"%",CT,1,1,FG_COL,BG_COL
  TEXT 160,132,STR$(V_FULL,3,2)+"V",CT,1,1,FG_COL,BG_COL
  TEXT 260,132,STR$((MN_TMOUT+IDLE_TOUT)\1000)+"s",CT,1,1,FG_COL,BG_COL
  
  TEXT 60,177,STR$(IDLE_BL)+"%",CT,1,1,FG_COL,BG_COL
  TEXT 160,177,STR$(V_EMPTY,3,2)+"V",CT,1,1,FG_COL,BG_COL
  
  TEXT 60,222,STR$(I_SCALE,4,1)+"A",CT,1,1,FG_COL,BG_COL
  TEXT 160,222,STR$(V_SHUTDOWN,3,2)+"V",CT,1,1,FG_COL,BG_COL
END SUB
  
SUB DRAW_DATA
  CLS(BG_COL)
  TEXT 160,10,"DATA",CT,8,1,FG_COL,BG_COL
  D_BUT 0, 0, 5, 210, 70, 24, BUT_COL, "Hours"
  D_BUT 1, 0, 85, 210, 70, 24, BUT_COL, "Days"
  D_BUT 2, 0, 165, 210, 70, 24, BUT_COL, "Weeks"
  D_BUT 3, 0, 245, 210, 70, 24, BUT_COL, "Exit"
  D_BUT 4, 0, 245, 6, 70, 24, BUT_COL, "Export"
END SUB
  
SUB DRAW_MAIN
  CLS(BG_COL)
  TEXT 160,10,"SILICON CHIP",CT,8,1,FG_COL,BG_COL
  TEXT 160,40,"BATTERY MANAGER",CT,8,1,FG_COL,BG_COL
  D_BUT 0, 0, 20, 182, 80, 25, BUT_COL, "Data"
  D_BUT 1, 0, 120, 182, 80, 25, BUT_COL, "Settings"
  D_BUT 2, 0, 220, 182, 80, 25, BUT_COL, "Calibrate"
  D_BUT 3, 0, 20, 212, 80, 25, BUT_COL, "Triggers"
  D_BUT 4, 0, 120, 212, 80, 25, BUT_COL, "Balancer"
  DISPLAY_TOUT=TIMER  ''reset on coming back to main
END SUB
  
FUNCTION SAMPLE_PATTERN(S AS INTEGER)
  ''map sample_state to channel
  SAMPLE_PATTERN=1
  IF S=2 OR S=3 THEN SAMPLE_PATTERN=2
  IF S=6 OR S=7 THEN SAMPLE_PATTERN=3
  IF S=10 OR S=11 THEN SAMPLE_PATTERN=4
END FUNCTION
  
SUB SAMPLE_MANAGER    ''can be called from anywhere to handle sample taking, updated 7 stage= V/I/V/I/V/I/V/I int
  STATIC INTEGER SAMPLE_STATE=0   ''state machine
  ''states are:
  '0=>1 = channel 1
  '2=>3 = channel 2
  '4=>5 = channel 1
  '6=>7 = channel 3
  '8=>9 = channel 1
  '10=>11 = channel 4
  '12=>13 = channel 1
  '14=process data
  STATIC INTEGER SAMPLE_TOUT=0 ''to check for sampling timeouts
  STATIC INTEGER LAST_SAMPLE_STATE=0
  LOCAL FLOAT NEW_ACTUAL(6)
  SELECT CASE SAMPLE_STATE
      ''start samples
    CASE 0,2,4,6,8,10,12
      START_ADC(SAMPLE_PATTERN(SAMPLE_STATE))
      SAMPLE_TOUT=TIMER
      SAMPLE_STATE=SAMPLE_STATE+1
      ''check if samples done/timeout
    CASE 1,3,5,7,9,11,13
      if CHECK_ADC_DONE(SAMPLE_PATTERN(SAMPLE_STATE)) > 0 THEN
        NEW_RAW((SAMPLE_STATE+1)\2)=GET_ADC_RESULT()
        SAMPLE_STATE=SAMPLE_STATE+1  ''avoid timeout
      ELSEIF (TIMER-SAMPLE_TOUT)> ADC_TOUT THEN
        NEW_RAW(1)=-1                ''flag timeout
        SAMPLE_STATE=SAMPLE_STATE+1  ''move on
      ENDIF
      ''process data
    CASE 14
      NEW_RAW(8)=PIN(SHUNT_ADC)  'this is in volts
      IF  NEW_RAW(1)<0 THEN
        'PRINT "SAMPLE CYCLE ERROR"
      ELSE
        RAW_ACTUAL(1)=(NEW_RAW(1)+NEW_RAW(3)+NEW_RAW(5)+NEW_RAW(7))\4  ''this is used as a flag
        RAW_ACTUAL(3)=NEW_RAW(2)  ''this is used as a flag
        RAW_ACTUAL(4)=NEW_RAW(4)  ''this is used as a flag
        RAW_ACTUAL(5)=NEW_RAW(6)  ''this is used as a flag
        ''values for calibration
        IF NEW_RAW(2)>800000 THEN I_RATIO(2)=(NEW_RAW(1)+NEW_RAW(3))/(NEW_RAW(2)*2) ELSE I_RATIO(2)=1
        IF NEW_RAW(4)>800000 THEN I_RATIO(3)=(NEW_RAW(3)+NEW_RAW(5))/(NEW_RAW(4)*2) ELSE I_RATIO(3)=1
        IF NEW_RAW(6)>800000 THEN I_RATIO(4)=(NEW_RAW(5)+NEW_RAW(7))/(NEW_RAW(6)*2) ELSE I_RATIO(4)=1
        ''debugging
        'PRINT I_RATIO(2),"  ",I_RATIO(3),"   ",I_RATIO(4)
        ''actual calcs
        NEW_ACTUAL(1)=(NEW_RAW(1)+NEW_RAW(3)+NEW_RAW(5)+NEW_RAW(7))*V_CAL(1)/4
        NEW_ACTUAL(2)=NEW_RAW(8)*I_CAL(1)  ''this is a simple shunt
        NEW_ACTUAL(3)=(((NEW_RAW(1)+NEW_RAW(3))*V_CAL(1)/2)-(NEW_RAW(2))*V_CAL(2))*I_CAL(2)  ''differential voltage
        NEW_ACTUAL(4)=(((NEW_RAW(3)+NEW_RAW(5))*V_CAL(1)/2)-(NEW_RAW(4))*V_CAL(3))*I_CAL(3)  ''differential voltage
        NEW_ACTUAL(5)=(((NEW_RAW(5)+NEW_RAW(7))*V_CAL(1)/2)-(NEW_RAW(6))*V_CAL(4))*I_CAL(4)  ''differential voltage
        'NEW_ACTUAL(3)=((NEW_RAW(1)+NEW_RAW(3))\2-NEW_RAW(2))*V_CAL(2)*I_CAL(2) ''these are differential voltages
        'NEW_ACTUAL(4)=((NEW_RAW(3)+NEW_RAW(5))\2-NEW_RAW(4))*V_CAL(3)*I_CAL(3) ''these are differential voltages
        'NEW_ACTUAL(5)=((NEW_RAW(5)+NEW_RAW(7))\2-NEW_RAW(6))*V_CAL(4)*I_CAL(4) ''these are differential voltages
        ''unsmoothed
        ACTUAL(1)=NEW_ACTUAL(1)
        ACTUAL(2)=NEW_ACTUAL(2)
        ACTUAL(3)=NEW_ACTUAL(3)
        ACTUAL(4)=NEW_ACTUAL(4)
        ACTUAL(5)=NEW_ACTUAL(5)
      ENDIF
      ''finish off the same as state 0
      NEW_RAW(1)=0'reset flag
      START_ADC(1)
      SAMPLE_TOUT=TIMER
      SAMPLE_STATE=1
      DATA_MANAGER    ''save and store data
      CHECK_TRIGGERS   ''check for and process trigger events
      UPDATE_BALANCER
  END SELECT
  ''debugging:
  'IF LAST_SAMPLE_STATE <> SAMPLE_STATE THEN PRINT "SAMPLE:";LAST_SAMPLE_STATE;">";SAMPLE_STATE;"(";TIMER-SAMPLE_TOUT;")": LAST_SAMPLE_STATE=SAMPLE_STATE
END SUB
  
SUB UPDATE_BALANCER
  GET_BALANCER_DATA
  'positive is into stack, negative into cell
  BB_I_H(0,BB_S_PTR)=BB_I(0)
  BB_I_H(1,BB_S_PTR)=BB_I(1)
  BB_I_H(2,BB_S_PTR)=BB_I(2)
  BB_I_H(3,BB_S_PTR)=BB_I(3)
  
  BB_V_H(0,BB_S_PTR)=BB_V(0)
  BB_V_H(1,BB_S_PTR)=BB_V(1)
  BB_V_H(2,BB_S_PTR)=BB_V(2)
  BB_V_H(3,BB_S_PTR)=BB_V(3)
  BB_V_H(4,BB_S_PTR)=BB_V(4)
  
  BB_S_PTR = (BB_S_PTR+1) MOD BB_SAMPLES  'advance counter
END SUB
  
SUB GET_BALANCER_DATA
  LOCAL FLOAT V
  LOCAL INTEGER P,Q,R 'processing position
  'load a line from serial buffer
  'PRINT "GET_BALANCER_DATA"
  DO WHILE (LOC(#8)>0)
    DO WHILE ((LEN(B_BUFFER)<250) AND (RIGHT$(B_BUFFER,1) <> CHR$(10)) AND (RIGHT$(B_BUFFER,1) <> CHR$(13)))
      B_BUFFER=B_BUFFER+UCASE$(INPUT$(1, #8)) 'so we can handle either case
    LOOP
    'DO WHILE (INSTR(B_BUFFER,CHR$(10))>0) 'scan any complete lines we have
    'PRINT "BB:";B_BUFFER
    V=PARSE_BV("STACK") 'note upper!
    IF V>0 THEN BB_V(0)=V
    V=PARSE_BV("C1")
    IF V>0 THEN BB_V(1)=V
    V=PARSE_BV("C2")
    IF V>0 THEN BB_V(2)=V
    V=PARSE_BV("C3")
    IF V>0 THEN BB_V(3)=V
    V=PARSE_BV("C4")
    IF V>0 THEN BB_V(4)=V
    ''assume no balancing
    BB_I(0)=0
    BB_I(1)=0
    BB_I(2)=0
    BB_I(3)=0
    P=INSTR(B_BUFFER,"=>")  'balancing occurring
    IF P>0 THEN
      'PRINT "BALANCING OCCURRING"
      R=50  'no value given by BB
      IF INSTR(B_BUFFER,"STACK=>")> 0 THEN  'from stack to cell
        IF INSTR(B_BUFFER,"C1<=")>0 THEN BB_I(0)=-R 'cell 1
        IF INSTR(B_BUFFER,"C2<=")>0 THEN BB_I(1)=-R 'cell 2
        IF INSTR(B_BUFFER,"C3<=")>0 THEN BB_I(2)=-R 'cell 3
        IF INSTR(B_BUFFER,"C4<=")>0 THEN BB_I(3)=-R 'cell 4
      ENDIF
      IF INSTR(B_BUFFER,"STACK<=")> 0 THEN  'from cell to stack
        IF INSTR(B_BUFFER,"C1=>")>0 THEN BB_I(0)=R 'cell 1
        IF INSTR(B_BUFFER,"C2=>")>0 THEN BB_I(1)=R 'cell 2
        IF INSTR(B_BUFFER,"C3=>")>0 THEN BB_I(2)=R 'cell 3
        IF INSTR(B_BUFFER,"C4=>")>0 THEN BB_I(3)=R 'cell 4
      ENDIF
    ENDIF
    GET_BALANCER_STATUS
    'B_BUFFER=MID$(B_BUFFER,INSTR(B_BUFFER,CHR$(10))+1)'strip line away
    B_BUFFER="" 'assume properly terminated or error
    'LOOP
  LOOP
END SUB
  
SUB GET_BALANCER_STATUS
  ''check B_BUFFER and return status in BB_STATUS
  LOCAL STRING B_TEMP
  LOCAL INTEGER P
  IF INSTR(B_BUFFER,"|")<1 THEN
    P=INSTR(B_BUFFER,"] ")
    IF P>0 THEN
      B_TEMP=MID$(B_BUFFER,P+2,30)
      'PRINT "B_STAT:";B_TEMP
      BB_STATUS=LEFT$(B_TEMP+PADDING,20)
    ENDIF
  ENDIF
END SUB
  
FUNCTION PARSE_BV(S AS STRING)  AS FLOAT'parse xx nn.nV format from balancer
  LOCAL INTEGER P,Q,R 'processing position
  LOCAL STRING T
  PARSE_BV=0
  P=INSTR(B_BUFFER,S)
  IF P>0 THEN
    R=P+LEN(S)+2  'past end of S and => or <=
    Q=INSTR(R,B_BUFFER,"V")
    IF Q>0 THEN
      T=MID$(B_BUFFER,R,Q-R)
      PARSE_BV=VAL(T)
      'PRINT S;"---";T;"---";PARSE_BV
    ENDIF
  ENDIF
  IF PARSE_BV<0 THEN PARSE_BV=0 'negative values are meaningless, but possible
END FUNCTION
  
SUB DATA_MANAGER
  LOCAL INTEGER S_PERIODS '' to adjust AH/WH
  LOCAL FLOAT AH_NOW, WH_NOW
  LOCAL INTEGER S_NUM
  LOCAL INTEGER I,J,NEW_H_PTR
  LOCAL FLOAT DATA_BUFFER(6)
  LOCAL INTEGER DATA_COUNT  ' if not all valid
  S_NUM=(TIME_SERIAL()\5) MOD 720 ''5 second periods
  'PRINT S_NUM;":";TIME_SERIAL()/86400;":";TIME_SERIAL()
  'update AH/WH usage
  S_PERIODS=(S_NUM + 720 - SAMPLE_STATE) MOD 720  'this takes care of occasional missed samples
  IF RAW_ACTUAL(1)>=0 THEN   'data is valid
    AH_NOW = (ACTUAL(2)+ACTUAL(3)+ACTUAL(4)+ACTUAL(5)) * S_PERIODS / 720  'sum of currents times interval in hours
    AH_SINCEF = AH_SINCEF + AH_NOW
    AH_SINCEE = AH_SINCEE + AH_NOW
    WH_NOW = AH_NOW * ACTUAL(1)
    WH_SINCEF = WH_SINCEF + WH_NOW
    WH_SINCEE = WH_SINCEE + WH_NOW
    IF ACTUAL(1) < V_EMPTY THEN
      AH_SINCEE=0
      WH_SINCEE=0
      USAGE_STATE = USAGE_STATE OR &H1  'has reached empty state
    ENDIF
    IF ACTUAL(1) > V_FULL THEN
      AH_SINCEF=0
      WH_SINCEF=0
      USAGE_STATE = USAGE_STATE OR &H2  'has reached full state
    ENDIF
  ENDIF
  IF SAMPLE_STATE < S_NUM THEN  'new sample in current hour
    'PRINT "SAMPLE:";S_NUM;":";SAMPLE_STATE
    ''need to clean up old samples from S_NUM to SAMPLE_STATE, but check for off by one.
    ''SAMPLE_STATE+1 to S_NUM (which should usually be the same, current sample about to be written)
    FOR J= SAMPLE_STATE+1 TO S_NUM
      SAMPLES(1,J)=-1'clear and flag
    NEXT J
    'PRINT "CLEARED:";SAMPLE_STATE+1;" to ";S_NUM
    FOR I=1 TO 5
      SAMPLES(I,S_NUM)=ACTUAL(I)    ''store
    NEXT I
    SAMPLE_STATE=S_NUM              ''update state
  ENDIF
  IF S_NUM < SAMPLE_STATE THEN    'hour expired or other rollover
    SAMPLE_STATE=0  ''reset
    'PRINT "HOUR EXPIRED"
    FOR I = 1 to 5
      DATA_BUFFER(I)=0
    NEXT I
    DATA_COUNT=0
    FOR J = 1 TO 720
      IF SAMPLES(1,J)>0 THEN      ''valid data
        FOR I = 1 TO 5
          DATA_BUFFER(I)=DATA_BUFFER(I)+SAMPLES(I,J)
        NEXT I
        DATA_COUNT=DATA_COUNT+1
      ENDIF
    NExt J
    IF DATA_COUNT>0 THEN    ''valid data in last hour
      'PRINT "DATA IN LAST HOUR:";DATA_COUNT
      IF H_START=0 THEN     ''prepare hour array and shift out if necessary
        H_START=TIME_SERIAL()\3600    ''hour number
        H_PTR=0                       ''first valid data
      ELSE
        NEW_H_PTR=(TIME_SERIAL()\3600)-H_START
        'IF NEW_H_PTR <= H_PTR THEN PRINT "TIME ERROR:";NEW_H_PTR
        IF NEW_H_PTR >= H_COUNT THEN NEW_H_PTR=ARCHIVE_HOUR_DATA(NEW_H_PTR) ''need to shift out old hourly data
        H_PTR=NEW_H_PTR''may need refining
      ENDIF
      FOR I = 1 TO 5
        H_SAMP(I,H_PTR)=DATA_BUFFER(I)/DATA_COUNT
      NEXT I
      VAR SAVE H_PTR,H_START,H_SAMP()
      'PRINT "Saved an hour of samples:";H_PTR
      'H_PTR=H_PTR+1  ''calculated automatically
    ELSE
      'PRINT "NO VALID DATA IN LAST HOUR"
    ENDIF
    IF (((TIME_SERIAL()\3600) MOD 24) = 0) THEN DAY_DATA_MANAGER  ''handle saving days of data in first hour after midnight
  ENDIF
  'ENDIF  '?
END SUB
  
SUB DAY_DATA_MANAGER  ''do what needs to be done for daily archiving, same as hourly, but different timescales
  LOCAL INTEGER I,J,NEW_D_PTR
  LOCAL FLOAT DATA_BUFFER(6)
  LOCAL INTEGER DATA_COUNT  ' if not all valid
  LOCAL INTEGER H_TO_START, H_TO_END
  H_TO_START  = (TIME_SERIAL()\3600)-24-H_START ''index of start of yesterday
  H_TO_END = H_TO_START+23    ''24 in a day
  if H_TO_START < 0 THEN H_TO_START = 0
  IF H_TO_END > H_COUNT-1 THEN H_TO_END = H_COUNT-1
  IF H_TO_END < H_TO_START THEN
    'PRINT "H_TO_STORE INVALID:";H_TO_START;"-";H_TO_END
    EXIT SUB
  ENDIF
  FOR I = 1 to 5
    DATA_BUFFER(I)=0
  NEXT I
  DATA_COUNT=0
  FOR J = H_TO_START TO H_TO_END
    IF H_SAMP(1,J)>0 THEN      ''valid data
      FOR I = 1 TO 5
        DATA_BUFFER(I)=DATA_BUFFER(I)+H_SAMP(I,J)
      NEXT I
      DATA_COUNT=DATA_COUNT+1
    ENDIF
  NExt J
  'PRINT "DATA IN LAST DAY:";DATA_COUNT;"=";H_TO_START;"-";H_TO_END
  IF DATA_COUNT>0 THEN    ''valid data in last hour
    IF D_START=0 THEN     ''prepare hour array and shift out if necessary
      D_START=TIME_SERIAL()\86400    ''day number
      D_PTR=0                       ''first valid data
    ELSE
      NEW_D_PTR=(TIME_SERIAL()\86400)-D_START
      'IF NEW_D_PTR <= D_PTR THEN PRINT "TIME ERROR:";NEW_D_PTR
      IF NEW_D_PTR >= D_COUNT THEN NEW_D_PTR=ARCHIVE_DAY_DATA(NEW_D_PTR) ''need to shift out old hourly data
      D_PTR=NEW_D_PTR''may need refining
    ENDIF
    FOR I = 1 TO 5
      D_SAMP(I,D_PTR)=DATA_BUFFER(I)/DATA_COUNT
    NEXT I
    VAR SAVE D_PTR,D_START,D_SAMP()
    'PRINT "Saved a day of samples:";D_PTR
  ELSE
    'PRINT "NO VALID DATA IN LAST DAY"
  ENDIF
END SUB
  
FUNCTION ARCHIVE_DAY_DATA(D AS INTEGER) AS INTEGER
  ARCHIVE_DAY_DATA = D
  if D < D_COUNT THEN EXIT FUNCTION ''don't do anything if there's room left
  LOCAL INTEGER OFFSET,I,J
  OFFSET = D - D_COUNT + 1 ''should be 1 most of the time
  FOR J = 0 TO D_COUNT - OFFSET - 1
    FOR I = 1 TO 5
      D_SAMP(I,J)=D_SAMP(I,J+OFFSET)    ''shift by offset
    NEXT I
  NEXT J
  D_START=D_START+OFFSET                      ''adjust sample pointer
  ARCHIVE_DAY_DATA=D_COUNT-1   ''should be 47 normally
  'PRINT "Day data shifted by ";OFFSET
END FUNCTION
  
  
FUNCTION ARCHIVE_HOUR_DATA(H AS INTEGER) AS INTEGER
  ARCHIVE_HOUR_DATA = H
  if H < H_COUNT THEN EXIT FUNCTION ''don't do anything if there's room left
  LOCAL INTEGER OFFSET,I,J
  OFFSET = H - H_COUNT + 1 ''should be 1 most of the time
  FOR J = 0 TO H_COUNT - OFFSET - 1
    FOR I = 1 TO 5
      H_SAMP(I,J)=H_SAMP(I,J+OFFSET)    ''shift by offset
    NEXT I
  NEXT J
  H_START=H_START+OFFSET                      ''adjust sample pointer
  ''VAR SAVE H_START,H_SAMP()              ''will be done later
  ARCHIVE_HOUR_DATA=H_COUNT-1   ''should be 47 normally
  'PRINT "Hour data shifted by ";OFFSET
END FUNCTION
  
FUNCTION TIME_SERIAL() AS INTEGER   ''convert current date/time into a time serial number, number of seconds since 1/1/1900 (time serial number * 86400)
  LOCAL INTEGER T(6)
  T(0)=val(mid$(DATE$,7,4)) 'year
  T(1)=val(mid$(DATE$,4,2)) 'month
  T(2)=val(mid$(DATE$,1,2)) 'day
  T(3)=val(mid$(TIME$,1,2)) 'hour/24
  T(4)=val(mid$(TIME$,4,2)) 'minute
  T(5)=val(mid$(TIME$,7,2)) 'second
  TIME_SERIAL=TIME_SERIAL+T(2)+1  'from start of current month
  IF T(1)=12 THEN TIME_SERIAL=TIME_SERIAL+IS_LEAP_YEAR(T(0))+334
  IF T(1)=11 THEN TIME_SERIAL=TIME_SERIAL+IS_LEAP_YEAR(T(0))+304
  IF T(1)=10 THEN TIME_SERIAL=TIME_SERIAL+IS_LEAP_YEAR(T(0))+273
  IF T(1)=9 THEN TIME_SERIAL=TIME_SERIAL+IS_LEAP_YEAR(T(0))+243
  IF T(1)=8 THEN TIME_SERIAL=TIME_SERIAL+IS_LEAP_YEAR(T(0))+212
  IF T(1)=7 THEN TIME_SERIAL=TIME_SERIAL+IS_LEAP_YEAR(T(0))+181
  IF T(1)=6 THEN TIME_SERIAL=TIME_SERIAL+IS_LEAP_YEAR(T(0))+151
  IF T(1)=5 THEN TIME_SERIAL=TIME_SERIAL+IS_LEAP_YEAR(T(0))+120
  IF T(1)=4 THEN TIME_SERIAL=TIME_SERIAL+IS_LEAP_YEAR(T(0))+90
  IF T(1)=3 THEN TIME_SERIAL=TIME_SERIAL+IS_LEAP_YEAR(T(0))+59
  IF T(1)=2 THEN TIME_SERIAL=TIME_SERIAL+31
  'January is already start of year
  DO WHILE(T(0)>1900)
    T(0)=T(0)-1
    TIME_SERIAL=TIME_SERIAL+365+IS_LEAP_YEAR(T(0))
  LOOP
  TIME_SERIAL=TIME_SERIAL*86400+T(3)*3600+T(4)*60+T(5)
END FUNCTION
  
FUNCTION IS_LEAP_YEAR(Y AS INTEGER) AS INTEGER
  IS_LEAP_YEAR=0
  IF ((Y\4)*4)=Y THEN IS_LEAP_YEAR =1
  IF ((Y\100)*100)=Y THEN IS_LEAP_YEAR =0
  IF ((Y\400)*400)=Y THEN IS_LEAP_YEAR =1
END FUNCTION
  
SUB WAIT_FOR_RELEASE
  DO WHILE (CHECK_SCREEN_TOUCH()=1)
    PAUSE 100
  LOOP
END SUB
  
FUNCTION CHECK_SCREEN_TOUCH() AS INTEGER
  LOCAL PIN_10_SAVE AS INTEGER
  PIN_10_SAVE=PIN(10)     ''save state
  pin(10)=1             ''power on so that touch pin is not pulled down
  CHECK_SCREEN_TOUCH=0
  IF (PIN(15)=0) THEN CHECK_SCREEN_TOUCH=1
  pin(10)=PIN_10_SAVE     'restore
END FUNCTION
  
SUB SET_BACKLIGHT(B AS INTEGER)
  PWM 2,50000,B
  'PRINT "SET_BACKLIGHT:";B
END SUB
  
Sub LCD_ON
  SetPin 10,DOUT
  pin(10)=1
  GUI RESET LCDPANEL        ''redo init, this should reinstate all control lines
End Sub
  
Sub LCD_OFF
  'PRINT "LCD OFF"
  Poke word &hBF886034,9      ''force control lines off
  Poke word &hBF886134,36876
  'Poke word &hBF886134,36868
End Sub
  
SUB START_ADC(C AS INTEGER)   ''start conversion on channel c
  LOCAL INTEGER C_MASK,JUNK,TMOUT
  C_MASK=0    ''no channels
  'LOCAL PIN_10_SAVE AS INTEGER
  'PIN_10_SAVE=PIN(10)     ''save state
  'pin(10)=1             ''power on so that touch pin is not pulled down
  SPI OPEN 2000000, 3, 8
  if C = 1 THEN C_MASK=&h10
  if C = 2 THEN C_MASK=&h20
  if C = 3 THEN C_MASK=&h40
  if C = 4 THEN C_MASK=&h80
  pin(ADC_CS)=0
  ''40 DIN high bits=reset
  JUNK=SPI(255)
  JUNK=SPI(255)
  JUNK=SPI(255)
  JUNK=SPI(255)
  JUNK=SPI(255)
  pin(ADC_CS)=1
  pin(ADC_CS)=0
  JUNK=SPI(8)   ''write MODE, 24 bits
  JUNK=SPI(&h38) ''single mode, returns to pwoer down after
  JUNK=SPI(&h07) ''sinc4, no parity, FS9-FS8=3
  JUNK=SPI(&hFF) ''FS7-FS0=FF
  pin(ADC_CS)=1
  pin(ADC_CS)=0
  JUNK=SPI(16)   ''write CONFIG, 24 bits
  JUNK=SPI(&H00) ''CHOP off
  JUNK=SPI(C_MASK)
  JUNK=SPI(&H48) ''unipolar, gain=1,
  pin(ADC_CS)=1
  SPI CLOSE
  'pin(10)=PIN_10_SAVE     'restore
END SUB
  
FUNCTION CHECK_ADC_DONE(C AS INTEGER) AS INTEGER
  LOCAL INTEGER JUNK
  CHECK_ADC_DONE=0
  'LOCAL PIN_10_SAVE AS INTEGER
  'PIN_10_SAVE=PIN(10)     ''save state
  'pin(10)=1             ''power on so that touch pin is not pulled down
  SPI OPEN 2000000, 3, 8
  pin(ADC_CS)=0
  JUNK=SPI(64)  ''read status
  JUNK=SPI(0)
  pin(ADC_CS)=1
  if (JUNK AND 7) = (C+3) THEN CHECK_ADC_DONE=1
  SPI CLOSE
  'pin(10)=PIN_10_SAVE     'restore
END FUNCTION
  
FUNCTION GET_ADC_RESULT() AS INTEGER
  LOCAL INTEGER JUNK
  GET_ADC_RESULT=-1
  'LOCAL PIN_10_SAVE AS INTEGER
  'PIN_10_SAVE=PIN(10)     ''save state
  'pin(10)=1             ''power on so that touch pin is not pulled down
  SPI OPEN 2000000, 3, 8
  pin(ADC_CS)=0
  JUNK=SPI(88)  ''read data
  GET_ADC_RESULT=SPI(0)*65536        ''load valid data
  GET_ADC_RESULT=GET_ADC_RESULT + SPI(0)*256
  GET_ADC_RESULT=GET_ADC_RESULT + SPI(0)
  pin(ADC_CS)=1
  'print GET_ADC_RESULT
  SPI CLOSE
  'pin(10)=PIN_10_SAVE     'restore
END FUNCTION
  
FUNCTION GET_ADC(C AS INTEGER) AS FLOAT   ''blocking conversion
  GET_ADC=-1'default fail value
  LOCAL INTEGER C_MASK,JUNK,TMOUT
  TMOUT=2000
  C_MASK=0    ''no channels
  'LOCAL PIN_10_SAVE AS INTEGER
  'PIN_10_SAVE=PIN(10)     ''save state
  'pin(10)=1             ''power on so that touch pin is not pulled down
  SPI OPEN 2000000, 3, 8
  if C = 1 THEN C_MASK=&h10
  if C = 2 THEN C_MASK=&h20
  if C = 3 THEN C_MASK=&h40
  if C = 4 THEN C_MASK=&h80
  pin(ADC_CS)=0
  ''40 DIN high bits=reset
  JUNK=SPI(255)
  JUNK=SPI(255)
  JUNK=SPI(255)
  JUNK=SPI(255)
  JUNK=SPI(255)
  pin(ADC_CS)=1
  pin(ADC_CS)=0
  JUNK=SPI(8)   ''write MODE, 24 bits
  JUNK=SPI(&h38) ''single mode, returns to pwoer down after
  JUNK=SPI(&h07) ''sinc4, no parity, FS9-FS8=3
  JUNK=SPI(&hFF) ''FS7-FS0=FF
  pin(ADC_CS)=1
  pin(ADC_CS)=0
  JUNK=SPI(16)   ''write CONFIG, 24 bits
  JUNK=SPI(&H00) ''CHOP off
  JUNK=SPI(C_MASK)
  JUNK=SPI(&H48) ''unipolar, gain=1,
  pin(ADC_CS)=1
  DO WHILE(TMOUT>0)
    pin(ADC_CS)=0
    JUNK=SPI(64)  ''read status
    JUNK=SPI(0)
    pin(ADC_CS)=1
    'PRINT JUNK
    if (JUNK AND 7) = (C+3) THEN
      TMOUT=-1
      pin(ADC_CS)=0
      JUNK=SPI(88)  ''read data
      GET_ADC=SPI(0)*65536        ''load valid data
      GET_ADC=GET_ADC + SPI(0)*256
      GET_ADC=GET_ADC + SPI(0)
      pin(ADC_CS)=1
    END IF
    PAUSE 100
    TMOUT=TMOUT-100
  LOOP
  'Print "DATA "
  'pin(ADC_CS)=0
  'print hex$(SPI(88))   ''DATA, 24 bits
  'print hex$(SPI(0))
  'print hex$(SPI(0))
  'print hex$(SPI(0))
  'pin(ADC_CS)=1
  SPI CLOSE
  'pin(10)=PIN_10_SAVE     'restore
END FUNCTION
  
  
FUNCTION GET_ADC_FAST(C AS INTEGER) AS FLOAT   ''uses lower filter word for faster conversion
  GET_ADC_FAST=-1000000'default fail value
  LOCAL INTEGER C_MASK,JUNK,TMOUT
  TMOUT=200
  C_MASK=0    ''no channels
  'LOCAL PIN_10_SAVE AS INTEGER
  'PIN_10_SAVE=PIN(10)     ''save state
  'pin(10)=1             ''power on so that touch pin is not pulled down
  SPI OPEN 2000000, 3, 8
  if C = 1 THEN C_MASK=&h10
  if C = 2 THEN C_MASK=&h20
  if C = 3 THEN C_MASK=&h40
  if C = 4 THEN C_MASK=&h80
  pin(ADC_CS)=0
  ''40 DIN high bits=reset
  JUNK=SPI(255)
  JUNK=SPI(255)
  JUNK=SPI(255)
  JUNK=SPI(255)
  JUNK=SPI(255)
  pin(ADC_CS)=1
  pin(ADC_CS)=0
  JUNK=SPI(8)   ''write MODE, 24 bits
  JUNK=SPI(&h38) ''single mode, returns to pwoer down after
  JUNK=SPI(&h00) ''sinc4, no parity, FS9-FS8=0
  JUNK=SPI(32) ''FS7-FS0=value=filter word if FS9:FS8=0
  pin(ADC_CS)=1
  pin(ADC_CS)=0
  JUNK=SPI(16)   ''write CONFIG, 24 bits
  JUNK=SPI(&H00) ''CHOP off
  JUNK=SPI(C_MASK)
  JUNK=SPI(&H48) ''unipolar, gain=1,
  pin(ADC_CS)=1
  DO WHILE(TMOUT>0)
    pin(ADC_CS)=0
    JUNK=SPI(64)  ''read status
    JUNK=SPI(0)
    pin(ADC_CS)=1
    'PRINT JUNK
    if (JUNK AND 7) = (C+3) THEN
      TMOUT=-1
      pin(ADC_CS)=0
      JUNK=SPI(88)  ''read data
      GET_ADC_FAST=SPI(0)*65536        ''load valid data
      GET_ADC_FAST=GET_ADC_FAST + SPI(0)*256
      GET_ADC_FAST=GET_ADC_FAST + SPI(0)
      pin(ADC_CS)=1
    END IF
    PAUSE 10
    TMOUT=TMOUT-10
  LOOP
  'Print "DATA "
  'pin(ADC_CS)=0
  'print hex$(SPI(88))   ''DATA, 24 bits
  'print hex$(SPI(0))
  'print hex$(SPI(0))
  'print hex$(SPI(0))
  'pin(ADC_CS)=1
  SPI CLOSE
  'pin(10)=PIN_10_SAVE     'restore
END FUNCTION
  
  
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' Draw buttons and get button presses
  '
  ' The subrouting D_BUT will draw a button (normally used when drawing
  ' the screen for input).
  '
  ' The function CheckButtonPress() will check if a button has been touched.
  ' If it has it will set it to selected (reverse video) and return with the
  ' button's number.
  '
  ' The subroutine CheckButtonRelease will wait for the touch to be released
  ' and will then draw the button as normal.
  '
  ' These routines use the global arrays key_coord() and key_caption() to
  ' track the coordinates and size of each button and save its caption.
  '
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  
  ' draw a button
Sub D_BUT n As Integer, mode As Integer, x As Integer, y As Integer, w As Integer, h As Integer, c As Integer, s As String
  Local Integer bc, fc
  
  If mode = 0 Then
    key_coord(n,0) = x : key_coord(n,1) = y : key_coord(n,2) = w : key_coord(n,3) = h
    key_coord(n,4) = c : key_caption(n) = s
  EndIf
  
  If mode > 1 Then
    bc = key_coord(n,4) : fc = 0    ' draw in reverse video if it is being touched
  Else
    bc = 0 : fc = key_coord(n,4)    ' a normal (untouched) button
  EndIf
  
  RBox key_coord(n,0), key_coord(n,1), key_coord(n,2), key_coord(n,3), , key_coord(n,4), bc)
  Text key_coord(n,0) + key_coord(n,2)/2, key_coord(n,1) + key_coord(n,3)/2, key_caption(n), CM, , , fc, bc
End Sub
  
  ' check if a button has been touch and animate the button's image
  ' returns the button's number
Function CheckButtonPress(startn As Integer, endn As Integer) As Integer
  Local Integer xt, yellowt, n
  
  CheckButtonPress = -1
  If Touch(x) <> -1 Then
    ' we have a touch
    'WatchDog 1200000
    xt = Touch(x)
    yellowt = Touch(y)
    ' scan the array key_coord() to see if the touch was within the
    ' boundaries of a button
    For n = startn To endn
      If xt > key_coord(n,0) And xt < key_coord(n,0) + key_coord(n,2) And yellowt > key_coord(n,1) And yellowt < key_coord(n,1) + key_coord(n,3) Then
        ' we have a button press
        ' draw the button as pressed
        D_BUT n, 2
        CheckButtonPress = n
        Exit For
      EndIf
    Next n
  EndIf
End Function
  
  
  ' wait for the touch to be released and then draw the button as normal
Sub CheckButtonRelease n As Integer
  ' if a button is currently down check if it has been released
  Do While Touch(x) <> -1
    SAMPLE_MANAGER
  Loop   ' wait for the button to be released
  D_BUT n, 1                  ' draw the button as normal (ie, not pressed)
End Sub
  
  
  
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' this handy routine draws a message box with an OK button
  ' then waits for the button to be touched
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub MessageBox s1 As String, s2 As String
  Local Integer w
  If Len(s1) > Len(s2) Then w = Len(s1) Else w = Len(s2)
  w = w * 8     ' get the width of the text (used for the box width)
  
  ' draw the box and the message in it
  RBox MM.HRes/2 - w - 20, 60, w * 2 + 40, 130, , FG_COL, 0
  Text MM.HRes/2, 70, s1, CT, 1, 2, FG_COL
  Text MM.HRes/2, 100, s2, CT, 1, 2, FG_COL
  
  ' draw the OK button
  RBox 110, 140, 100, 34, , BUT_COL
  Text MM.HRes/2, 157, "OK", CM, 1, 2, BUT_COL
  
  ' wait for the button to be touched
  'WatchDog 1200000
  Do While Not (Touch(x) > 110 And Touch(x) < 210 And Touch(y) > 140 And Touch(y) < 180) : Loop
  
  ' draw the OK button as depressed
  RBox 110, 140, 100, 34, , BUT_COL, BUT_COL
  Text MM.HRes/2, 157, "OK", CM, 1, 2, 0, BUT_COL
  
  ' wait for the touch to be removed
  Do While Touch(x) <> -1 : Loop
End Sub
  
FUNCTION OK_CANCEL_BOX(S1 AS STRING, S2 AS STRING) AS INTEGER   ''variant of MessageBox with two options
  OK_CANCEL_BOX=0
  Local Integer w
  If Len(s1) > Len(s2) Then w = Len(s1) Else w = Len(s2)
  w = w * 8     ' get the width of the text (used for the box width)
  if w < 108 THEN w = 108
  
  ' draw the box and the message in it
  RBox MM.HRes/2 - w - 20, 60, w * 2 + 40, 130, , FG_COL, 0
  Text MM.HRes/2, 70, s1, CT, 1, 2, FG_COL
  Text MM.HRes/2, 100, s2, CT, 1, 2, FG_COL
  
  ' draw the OK button
  RBox 55, 140, 100, 34, , BUT_COL
  Text 105, 157, "OK", CM, 1, 2, BUT_COL
  ' draw the CANCEL button
  RBox 165, 140, 100, 34, , BUT_COL
  Text 215, 157, "CANCEL", CM, 1, 2, BUT_COL
  'wait for press
  DO
    SAMPLE_MANAGER
    IF  (Touch(y) > 140 And Touch(y) < 180) THEN
      IF (TOUCH(x)>55 AND TOUCH(x)<155) THEN  ''OK
        RBox 55, 140, 100, 34, , BUT_COL, BUT_COL
        Text 105, 157, "OK", CM, 1, 2, 0, BUT_COL
        Do While Touch(x) <> -1 : SAMPLE_MANAGER : Loop
        OK_CANCEL_BOX=1
        EXIT FUNCTION
      ENDIF
      IF (TOUCH(x)>165 AND TOUCH(x)<265) THEN  ''CANCEL
        RBox 165, 140, 100, 34, , BUT_COL, BUT_COL
        Text 215, 157, "CANCEL", CM, 1, 2, 0, BUT_COL
        Do While Touch(x) <> -1 : SAMPLE_MANAGER : Loop
        OK_CANCEL_BOX=0
        EXIT FUNCTION
      ENDIF
    ENDIF
  LOOP
  
END FUNCTION
  
FUNCTION OK_CANCEL_BUTTONS() AS INTEGER   ''buttons only at bottom of screen
  OK_CANCEL_BUTTONS=0
  ' draw the OK button
  RBox 55, 200, 100, 34, , BUT_COL
  Text 105, 217, "OK", CM, 1, 2, BUT_COL
  ' draw the CANCEL button
  RBox 165, 200, 100, 34, , BUT_COL
  Text 215, 217, "CANCEL", CM, 1, 2, BUT_COL
  'wait for press
  DO
    SAMPLE_MANAGER
    IF  (Touch(y) > 200 And Touch(y) < 240) THEN
      IF (TOUCH(x)>55 AND TOUCH(x)<155) THEN  ''OK
        RBox 55, 200, 100, 34, , BUT_COL, BUT_COL
        Text 105, 217, "OK", CM, 1, 2, 0, BUT_COL
        Do While Touch(x) <> -1 : SAMPLE_MANAGER : Loop
        OK_CANCEL_BUTTONS=1
        EXIT FUNCTION
      ENDIF
      IF (TOUCH(x)>165 AND TOUCH(x)<265) THEN  ''CANCEL
        RBox 165, 200, 100, 34, , BUT_COL, BUT_COL
        Text 215, 217, "CANCEL", CM, 1, 2, 0, BUT_COL
        Do While Touch(x) <> -1 : SAMPLE_MANAGER : Loop
        OK_CANCEL_BUTTONS=0
        EXIT FUNCTION
      ENDIF
    ENDIF
  LOOP
END FUNCTION
  
SUB DRAW_NUMPAD(BUT_START AS INTEGER,TITLE AS STRING)
  CLS(BG_COL)
  D_BUT BUT_START,0, 66, 195, 60, 40, BUT_COL, "0"
  D_BUT BUT_START+1,0, 130, 195, 60, 40, BUT_COL, "1"
  D_BUT BUT_START+2,0, 194, 195, 60, 40, BUT_COL, "2"
  D_BUT BUT_START+3,0, 258, 195, 60, 40, BUT_COL, "3"
  D_BUT BUT_START+4,0, 130, 150, 60, 40, BUT_COL, "4"
  D_BUT BUT_START+5,0, 194, 150, 60, 40, BUT_COL, "5"
  D_BUT BUT_START+6,0, 258, 150, 60, 40, BUT_COL, "6"
  D_BUT BUT_START+7,0, 130, 105, 60, 40, BUT_COL, "7"
  D_BUT BUT_START+8,0, 194, 105, 60, 40, BUT_COL, "8"
  D_BUT BUT_START+9,0, 258, 105, 60, 40, BUT_COL, "9"
  D_BUT BUT_START+10,0, 66, 150, 60, 40, BUT_COL, "."
  
  D_BUT BUT_START+11,0, 2, 195, 60, 40, BUT_COL, "<-"
  D_BUT BUT_START+12,0, 2, 150, 60, 40, BUT_COL, "OK"
  D_BUT BUT_START+13,0, 2, 105, 60, 40, BUT_COL, "Cancel"
  TEXT 160,10,TITLE,CT,8,1,FG_COL,BG_COL
  
END SUB
  
  
FUNCTION NUMBERPAD(TITLE AS STRING) AS FLOAT
  NUMBERPAD=-1'invalid
  LOCAL STRING ENTRY
  ENTRY=""
  ''use high numbered buttons to not interfere with other screens
  LOCAL INTEGER BUT_START
  BUT_START=BUT_COUNT-15
  DRAW_NUMPAD(BUT_START,TITLE)
  DO
    SAMPLE_MANAGER
    BUT_PRESS=CheckButtonPress(BUT_START, BUT_START+13)
    IF BUT_PRESS >= 0 THEN
      CheckButtonRelease(BUT_PRESS)
      if BUT_PRESS = BUT_START THEN ENTRY=ENTRY+"0"
      if BUT_PRESS = BUT_START+1 THEN ENTRY=ENTRY+"1"
      if BUT_PRESS = BUT_START+2 THEN ENTRY=ENTRY+"2"
      if BUT_PRESS = BUT_START+3 THEN ENTRY=ENTRY+"3"
      if BUT_PRESS = BUT_START+4 THEN ENTRY=ENTRY+"4"
      if BUT_PRESS = BUT_START+5 THEN ENTRY=ENTRY+"5"
      if BUT_PRESS = BUT_START+6 THEN ENTRY=ENTRY+"6"
      if BUT_PRESS = BUT_START+7 THEN ENTRY=ENTRY+"7"
      if BUT_PRESS = BUT_START+8 THEN ENTRY=ENTRY+"8"
      if BUT_PRESS = BUT_START+9 THEN ENTRY=ENTRY+"9"
      if (BUT_PRESS = BUT_START+10) AND (INSTR(ENTRY,".") = 0)THEN ENTRY=ENTRY+"."  'only add one .
      if (BUT_PRESS = BUT_START+11) AND (LEN(ENTRY)>0) THEN ENTRY=left$(ENTRY,LEN(ENTRY)-1)
      IF ENTRY="." THEN ENTRY="0."
      IF LEN(ENTRY)>9 THEN ENTRY=LEFT$(ENTRY,9)     'truncate
      if BUT_PRESS = BUT_START+13 THEN NUMBERPAD=-1: EXIT FUNCTION
      if BUT_PRESS = BUT_START+12 THEN
        NUMBERPAD=VAL(ENTRY)
        IF OK_CANCEL_BOX("ACCEPT?",STR$(NUMBERPAD))>0 THEN EXIT FUNCTION  ''OK
        ''OTHERWISE CANCEL
        NUMBERPAD=-1
        DRAW_NUMPAD(BUT_START,TITLE)
      ENDIF
    ENDIF
    TEXT 0,45,RIGHT$(PADDING+ENTRY+"_",10),LT,8,2,FG_COL,HL_COL
  LOOP
  
END FUNCTION